; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --function-signature --scrub-attributes
; RUN: opt -S < %s -passes=inline,argpromotion | FileCheck %s --check-prefix=ARGPROMOTION

%S = type { ptr }

; Inlining should nuke the invoke (and any inlined calls) here even with
; argument promotion running along with it.
define void @zot() personality ptr @wibble {
; ARGPROMOTION-LABEL: define {{[^@]+}}@zot() personality ptr @wibble {
; ARGPROMOTION-NEXT:  bb:
; ARGPROMOTION-NEXT:    unreachable
; ARGPROMOTION:       hoge.exit:
; ARGPROMOTION-NEXT:    br label [[BB1:%.*]]
; ARGPROMOTION:       bb1:
; ARGPROMOTION-NEXT:    unreachable
; ARGPROMOTION:       bb2:
; ARGPROMOTION-NEXT:    [[TEMP:%.*]] = landingpad { ptr, i32 }
; ARGPROMOTION-NEXT:    cleanup
; ARGPROMOTION-NEXT:    unreachable
;
bb:
  invoke void @hoge()
  to label %bb1 unwind label %bb2

bb1:
  unreachable

bb2:
  %temp = landingpad { ptr, i32 }
  cleanup
  unreachable
}

define internal void @hoge() {
bb:
  %temp = call fastcc ptr @spam(ptr @eggs)
  %temp1 = call fastcc ptr @spam(ptr @barney)
  unreachable
}

define internal fastcc ptr @spam(ptr %arg) {
bb:
  unreachable
}

define internal i1 @eggs(ptr %arg) {
; ARGPROMOTION-LABEL: define {{[^@]+}}@eggs() {
; ARGPROMOTION-NEXT:  bb:
; ARGPROMOTION-NEXT:    unreachable
;
bb:
  %temp = call zeroext i1 @barney(ptr %arg)
  unreachable
}

define internal i1 @barney(ptr %arg) {
bb:
  ret i1 undef
}

define i32 @test_inf_promote_caller(i32 %arg) {
; ARGPROMOTION-LABEL: define {{[^@]+}}@test_inf_promote_caller
; ARGPROMOTION-SAME: (i32 [[ARG:%.*]]) {
; ARGPROMOTION-NEXT:  bb:
; ARGPROMOTION-NEXT:    [[TEMP:%.*]] = alloca [[S:%.*]], align 8
; ARGPROMOTION-NEXT:    [[TEMP1:%.*]] = alloca [[S]], align 8
; ARGPROMOTION-NEXT:    [[TEMP2:%.*]] = call i32 @test_inf_promote_callee(ptr [[TEMP]], ptr [[TEMP1]])
; ARGPROMOTION-NEXT:    ret i32 0
;
bb:
  %temp = alloca %S
  %temp1 = alloca %S
  %temp2 = call i32 @test_inf_promote_callee(ptr %temp, ptr %temp1)

  ret i32 0
}

define internal i32 @test_inf_promote_callee(ptr %arg, ptr %arg1) {
; ARGPROMOTION-LABEL: define {{[^@]+}}@test_inf_promote_callee
; ARGPROMOTION-SAME: (ptr [[ARG:%.*]], ptr [[ARG1:%.*]]) {
; ARGPROMOTION-NEXT:  bb:
; ARGPROMOTION-NEXT:    [[TEMP2:%.*]] = load ptr, ptr [[ARG1]], align 8
; ARGPROMOTION-NEXT:    [[TEMP4:%.*]] = load ptr, ptr [[ARG]], align 8
; ARGPROMOTION-NEXT:    [[TEMP5:%.*]] = call i32 @test_inf_promote_callee(ptr [[TEMP4]], ptr [[TEMP2]])
; ARGPROMOTION-NEXT:    ret i32 0
;
bb:
  %temp2 = load ptr, ptr %arg1
  %temp4 = load ptr, ptr %arg
  %temp5 = call i32 @test_inf_promote_callee(ptr %temp4, ptr %temp2)

  ret i32 0
}

declare i32 @wibble(...)
