; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+experimental-b -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefix=RV32IB
; RUN: llc -mtriple=riscv32 -mattr=+experimental-zbc -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefix=RV32IBC

declare i32 @llvm.riscv.clmul.i32(i32 %a, i32 %b)

define i32 @clmul32(i32 %a, i32 %b) nounwind {
; RV32IB-LABEL: clmul32:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    clmul a0, a0, a1
; RV32IB-NEXT:    ret
;
; RV32IBC-LABEL: clmul32:
; RV32IBC:       # %bb.0:
; RV32IBC-NEXT:    clmul a0, a0, a1
; RV32IBC-NEXT:    ret
  %tmp = call i32 @llvm.riscv.clmul.i32(i32 %a, i32 %b)
 ret i32 %tmp
}

declare i32 @llvm.riscv.clmulh.i32(i32 %a, i32 %b)

define i32 @clmul32h(i32 %a, i32 %b) nounwind {
; RV32IB-LABEL: clmul32h:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    clmulh a0, a0, a1
; RV32IB-NEXT:    ret
;
; RV32IBC-LABEL: clmul32h:
; RV32IBC:       # %bb.0:
; RV32IBC-NEXT:    clmulh a0, a0, a1
; RV32IBC-NEXT:    ret
  %tmp = call i32 @llvm.riscv.clmulh.i32(i32 %a, i32 %b)
 ret i32 %tmp
}

declare i32 @llvm.riscv.clmulr.i32(i32 %a, i32 %b)

define i32 @clmul32r(i32 %a, i32 %b) nounwind {
; RV32IB-LABEL: clmul32r:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    clmulr a0, a0, a1
; RV32IB-NEXT:    ret
;
; RV32IBC-LABEL: clmul32r:
; RV32IBC:       # %bb.0:
; RV32IBC-NEXT:    clmulr a0, a0, a1
; RV32IBC-NEXT:    ret
  %tmp = call i32 @llvm.riscv.clmulr.i32(i32 %a, i32 %b)
 ret i32 %tmp
}
