# --------------------------------------------------------------------------
# ⚠️ WARNING - AUTO-GENERATED CODE - DO NOT EDIT ⚠️
# ⚙️ Generated by 'python -m opgen'
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License.
# --------------------------------------------------------------------------
# pylint: disable=W0221,W0222,R0901,W0237
# mypy: disable-error-code=override
# ruff: noqa: N801,E741
# ruff: noqa: D214,D402,D405,D411,D412,D416,D417
# --------------------------------------------------------------------------

from __future__ import annotations

from typing import Optional, Sequence, Tuple, TypeVar, Union

from onnx import GraphProto, TensorProto
from onnx.defs import get_schema
from typing_extensions import TypeAlias

from onnxscript.onnx_types import (
    BOOL,
    COMPLEX64,
    COMPLEX128,
    DOUBLE,
    FLOAT,
    FLOAT16,
    INT8,
    INT16,
    INT32,
    INT64,
    STRING,
    UINT8,
    UINT16,
    UINT32,
    UINT64,
)
from onnxscript.values import Op, Opset


class Opset1(Opset):
    def __new__(cls):
        return Opset.__new__(cls, "", 1)

    T_Abs = TypeVar("T_Abs", DOUBLE, FLOAT, FLOAT16)

    def Abs(self, X: T_Abs, *, consumed_inputs: Optional[Sequence[int]] = None) -> T_Abs:
        r"""[🌐 Abs(1)](https://onnx.ai/onnx/operators/onnx__Abs.html#abs-1 "Online Documentation")


        Absolute takes one input data (Tensor<T>) and produces one output data
        (Tensor<T>) where the absolute is, y = abs(x), is applied to
        the tensor elementwise.


        Args:
            X: Input tensor

            consumed_inputs: legacy optimization attribute.
        """

        schema = get_schema("Abs", 1, "")
        op = Op(self, "Abs", schema)
        return op(*self._prepare_inputs(schema, X), consumed_inputs=consumed_inputs)

    T_Add = TypeVar("T_Add", DOUBLE, FLOAT, FLOAT16)

    def Add(
        self,
        A: T_Add,
        B: T_Add,
        *,
        axis: Optional[int] = None,
        broadcast: int = 0,
        consumed_inputs: Optional[Sequence[int]] = None,
    ) -> T_Add:
        r"""[🌐 Add(1)](https://onnx.ai/onnx/operators/onnx__Add.html#add-1 "Online Documentation")


        Performs element-wise binary addition (with limited broadcast support).

        If necessary the right-hand-side argument will be broadcasted to match the
        shape of left-hand-side argument. When broadcasting is specified, the second
        tensor can either be of element size 1 (including a scalar tensor and any
        tensor with rank equal to or smaller than the first tensor), or having its
        shape as a contiguous subset of the first tensor's shape. The starting of the
        mutually equal shape is specified by the argument "axis", and if it is not set,
        suffix matching is assumed. 1-dim expansion doesn't work yet.

        For example, the following tensor shapes are supported (with broadcast=1):

          shape(A) = (2, 3, 4, 5), shape(B) = (,), i.e. B is a scalar tensor
          shape(A) = (2, 3, 4, 5), shape(B) = (1, 1), i.e. B is an 1-element tensor
          shape(A) = (2, 3, 4, 5), shape(B) = (5,)
          shape(A) = (2, 3, 4, 5), shape(B) = (4, 5)
          shape(A) = (2, 3, 4, 5), shape(B) = (3, 4), with axis=1
          shape(A) = (2, 3, 4, 5), shape(B) = (2), with axis=0

        Attribute `broadcast=1` needs to be passed to enable broadcasting.


        Args:
            A: First operand, should share the type with the second operand.

            B: Second operand. With broadcasting can be of smaller size than A. If
                broadcasting is disabled it should be of the same size.

            axis: If set, defines the broadcast dimensions. See doc for details.

            broadcast: Pass 1 to enable broadcasting

            consumed_inputs: legacy optimization attribute.
        """

        schema = get_schema("Add", 1, "")
        op = Op(self, "Add", schema)
        return op(
            *self._prepare_inputs(schema, A, B),
            axis=axis,
            broadcast=broadcast,
            consumed_inputs=consumed_inputs,
        )

    T_And: TypeAlias = BOOL

    T1_And: TypeAlias = BOOL

    def And(
        self, A: T_And, B: T_And, *, axis: Optional[int] = None, broadcast: int = 0
    ) -> T1_And:
        r"""[🌐 And(1)](https://onnx.ai/onnx/operators/onnx__And.html#and-1 "Online Documentation")


        Returns the tensor resulted from performing the `and` logical operation
        elementwise on the input tensors `A` and `B`.

        If broadcasting is enabled, the right-hand-side argument will be broadcasted
        to match the shape of left-hand-side argument. See the doc of `Add` for a
        detailed description of the broadcasting rules.


        Args:
            A: Left input tensor for the logical operator.

            B: Right input tensor for the logical operator.

            axis: If set, defines the broadcast dimensions.

            broadcast: Enable broadcasting
        """

        schema = get_schema("And", 1, "")
        op = Op(self, "And", schema)
        return op(*self._prepare_inputs(schema, A, B), axis=axis, broadcast=broadcast)

    T_ArgMax = TypeVar(
        "T_ArgMax",
        DOUBLE,
        FLOAT,
        FLOAT16,
        INT16,
        INT32,
        INT64,
        INT8,
        UINT16,
        UINT32,
        UINT64,
        UINT8,
    )

    def ArgMax(self, data: T_ArgMax, *, axis: int = 0, keepdims: int = 1) -> INT64:
        r"""[🌐 ArgMax(1)](https://onnx.ai/onnx/operators/onnx__ArgMax.html#argmax-1 "Online Documentation")


        Computes the indices of the max elements of the input tensor's element along the
        provided axis. The resulting tensor has the same rank as the input if keepdims equals 1.
        If keepdims equal 0, then the resulted tensor have the reduced dimension pruned.
        The type of the output tensor is integer.

        Args:
            data: An input tensor.

            axis: The axis in which to compute the arg indices.

            keepdims: Keep the reduced dimension or not, default 1 means keep reduced
                dimension.
        """

        schema = get_schema("ArgMax", 1, "")
        op = Op(self, "ArgMax", schema)
        return op(*self._prepare_inputs(schema, data), axis=axis, keepdims=keepdims)

    T_ArgMin = TypeVar(
        "T_ArgMin",
        DOUBLE,
        FLOAT,
        FLOAT16,
        INT16,
        INT32,
        INT64,
        INT8,
        UINT16,
        UINT32,
        UINT64,
        UINT8,
    )

    def ArgMin(self, data: T_ArgMin, *, axis: int = 0, keepdims: int = 1) -> INT64:
        r"""[🌐 ArgMin(1)](https://onnx.ai/onnx/operators/onnx__ArgMin.html#argmin-1 "Online Documentation")


        Computes the indices of the min elements of the input tensor's element along the
        provided axis. The resulting tensor has the same rank as the input if keepdims equals 1.
        If keepdims equal 0, then the resulted tensor have the reduced dimension pruned.
        The type of the output tensor is integer.

        Args:
            data: An input tensor.

            axis: The axis in which to compute the arg indices.

            keepdims: Keep the reduced dimension or not, default 1 means keep reduced
                dimension.
        """

        schema = get_schema("ArgMin", 1, "")
        op = Op(self, "ArgMin", schema)
        return op(*self._prepare_inputs(schema, data), axis=axis, keepdims=keepdims)

    T_AveragePool = TypeVar("T_AveragePool", DOUBLE, FLOAT, FLOAT16)

    def AveragePool(
        self,
        X: T_AveragePool,
        *,
        auto_pad: str = "NOTSET",
        kernel_shape: Sequence[int],
        pads: Optional[Sequence[int]] = None,
        strides: Optional[Sequence[int]] = None,
    ) -> T_AveragePool:
        r"""[🌐 AveragePool(1)](https://onnx.ai/onnx/operators/onnx__AveragePool.html#averagepool-1 "Online Documentation")


         AveragePool consumes an input tensor X and applies average pooling across
         the tensor according to kernel sizes, stride sizes, and pad lengths.
         average pooling consisting of computing the average on all values of a
         subset of the input tensor according to the kernel size and downsampling the
         data into the output tensor Y for further processing. The output spatial shape will be following:
         ```
         output_spatial_shape[i] = floor((input_spatial_shape[i] + pad_shape[i] - kernel_spatial_shape[i]) / strides_spatial_shape[i] + 1)

         * pad_shape[i] is sum of pads along axis i
         ```

         `auto_pad` is a DEPRECATED attribute. If you are using them currently, the output spatial shape will be following:
         ```
         VALID: output_spatial_shape[i] = ceil((input_spatial_shape[i] - kernel_spatial_shape[i] + 1) / strides_spatial_shape[i])
         SAME_UPPER or SAME_LOWER: output_spatial_shape[i] = ceil(input_spatial_shape[i] / strides_spatial_shape[i])
         ```
         And pad shape will be following if `SAME_UPPER` or `SAME_LOWER`:
         ```
         pad_shape[i] = (output_spatial_shape[i] - 1) * strides_spatial_shape[i] + kernel_spatial_shape[i] - input_spatial_shape[i]
         ```
         The output of each pooling window is divided by the number of elements exclude pad.


        Args:
            X: Input data tensor from the previous operator; dimensions for image case
                are (N x C x H x W), where N is the batch size, C is the number of
                channels, and H and W are the height and the width of the data. For non
                image case, the dimensions are in the form of (N x C x D1 x D2 ... Dn),
                where N is the batch size. Optionally, if dimension denotation is in
                effect, the operation expects the input data tensor to arrive with the
                dimension denotation of [DATA_BATCH, DATA_CHANNEL, DATA_FEATURE,
                DATA_FEATURE ...].

            auto_pad: auto_pad must be either NOTSET, SAME_UPPER, SAME_LOWER or VALID.
                Where default value is NOTSET, which means explicit padding is used.
                SAME_UPPER or SAME_LOWER mean pad the input so that the output spatial
                size match the input.In case of odd number add the extra padding at the
                end for SAME_UPPER and at the beginning for SAME_LOWER. VALID mean no
                padding.

            kernel_shape: The size of the kernel along each axis.

            pads: Padding for the beginning and ending along each spatial axis, it can
                take any value greater than or equal to 0. The value represent the
                number of pixels added to the beginning and end part of the
                corresponding axis. `pads` format should be as follow [x1_begin,
                x2_begin...x1_end, x2_end,...], where xi_begin the number of pixels
                added at the beginning of axis `i` and xi_end, the number of pixels
                added at the end of axis `i`. This attribute cannot be used
                simultaneously with auto_pad attribute. If not present, the padding
                defaults to 0 along start and end of each spatial axis.

            strides: Stride along each spatial axis.
        """

        schema = get_schema("AveragePool", 1, "")
        op = Op(self, "AveragePool", schema)
        return op(
            *self._prepare_inputs(schema, X),
            auto_pad=auto_pad,
            kernel_shape=kernel_shape,
            pads=pads,
            strides=strides,
        )

    T_BatchNormalization = TypeVar("T_BatchNormalization", DOUBLE, FLOAT, FLOAT16)

    def BatchNormalization(
        self,
        X: T_BatchNormalization,
        scale: T_BatchNormalization,
        B: T_BatchNormalization,
        mean: T_BatchNormalization,
        var: T_BatchNormalization,
        *,
        consumed_inputs: Sequence[int],
        epsilon: float = 9.999999747378752e-06,
        is_test: int = 0,
        momentum: float = 0.8999999761581421,
        spatial: int = 1,
    ) -> Tuple[
        T_BatchNormalization,
        T_BatchNormalization,
        T_BatchNormalization,
        T_BatchNormalization,
        T_BatchNormalization,
    ]:
        r"""[🌐 BatchNormalization(1)](https://onnx.ai/onnx/operators/onnx__BatchNormalization.html#batchnormalization-1 "Online Documentation")


        Carries out batch normalization as described in the paper
        https://arxiv.org/abs/1502.03167. Depending on the mode it is being run,
        there are multiple cases for the number of outputs, which we list below:

        Output case #1: Y, mean, var, saved_mean, saved_var (training mode)
        Output case #2: Y (test mode)


        Args:
            X: The input 4-dimensional tensor of shape NCHW.

            scale: The scale as a 1-dimensional tensor of size C to be applied to the
                output.

            B: The bias as a 1-dimensional tensor of size C to be applied to the output.

            mean: The running mean (training) or the estimated mean (testing) as a
                1-dimensional tensor of size C.

            var: The running variance (training) or the estimated variance (testing) as
                a 1-dimensional tensor of size C.

            consumed_inputs: legacy optimization attribute.

            epsilon: The epsilon value to use to avoid division by zero, default is
                1e-5f.

            is_test: If set to nonzero, run spatial batch normalization in test mode,
                default is 0.

            momentum: Factor used in computing the running mean and variance.e.g.,
                running_mean = running_mean * momentum + mean * (1 - momentum), default
                is 0.9f.

            spatial: If true, compute the mean and variance across all spatial elements
                If false, compute the mean and variance across per feature.Default is 1.
        """

        schema = get_schema("BatchNormalization", 1, "")
        op = Op(self, "BatchNormalization", schema)
        return op(
            *self._prepare_inputs(schema, X, scale, B, mean, var),
            consumed_inputs=consumed_inputs,
            epsilon=epsilon,
            is_test=is_test,
            momentum=momentum,
            spatial=spatial,
        )

    T1_Cast = TypeVar(
        "T1_Cast",
        BOOL,
        DOUBLE,
        FLOAT,
        FLOAT16,
        INT16,
        INT32,
        INT64,
        INT8,
        UINT16,
        UINT32,
        UINT64,
        UINT8,
    )

    T2_Cast: TypeAlias = Union[
        BOOL, DOUBLE, FLOAT, FLOAT16, INT16, INT32, INT64, INT8, UINT16, UINT32, UINT64, UINT8
    ]

    def Cast(self, input: T1_Cast, *, to: str) -> T2_Cast:
        r"""[🌐 Cast(1)](https://onnx.ai/onnx/operators/onnx__Cast.html#cast-1 "Online Documentation")


        The operator casts the elements of a given input tensor to a data type
        specified by the 'to' argument and returns an output tensor of the same size in
        the converted type. The 'to' argument must be one of the data types specified
        in the 'DataType' enum field in the TensorProto message.
        NOTE: Casting to and from strings is not supported yet.


        Args:
            input: Input tensor to be cast.

            to: The data type to which the elements of the input tensor are cast.
                Strictly must be one of the types from DataType enum in TensorProto
        """

        schema = get_schema("Cast", 1, "")
        op = Op(self, "Cast", schema)
        return op(*self._prepare_inputs(schema, input), to=to)

    T_Ceil = TypeVar("T_Ceil", DOUBLE, FLOAT, FLOAT16)

    def Ceil(self, X: T_Ceil, *, consumed_inputs: Optional[Sequence[int]] = None) -> T_Ceil:
        r"""[🌐 Ceil(1)](https://onnx.ai/onnx/operators/onnx__Ceil.html#ceil-1 "Online Documentation")


        Ceil takes one input data (Tensor<T>) and produces one output data
        (Tensor<T>) where the ceil is, y = ceil(x), is applied to
        the tensor elementwise.


        Args:
            X: Input tensor

            consumed_inputs: legacy optimization attribute.
        """

        schema = get_schema("Ceil", 1, "")
        op = Op(self, "Ceil", schema)
        return op(*self._prepare_inputs(schema, X), consumed_inputs=consumed_inputs)

    T_Clip = TypeVar("T_Clip", DOUBLE, FLOAT, FLOAT16)

    def Clip(
        self,
        input: T_Clip,
        *,
        consumed_inputs: Optional[Sequence[int]] = None,
        max: Optional[float] = None,
        min: Optional[float] = None,
    ) -> T_Clip:
        r"""[🌐 Clip(1)](https://onnx.ai/onnx/operators/onnx__Clip.html#clip-1 "Online Documentation")


        Clip operator limits the given input within an interval. The interval is
        specified with arguments 'min' and 'max'. They default to
        numeric_limits::lowest() and numeric_limits::max() respectively.


        Args:
            input: Input tensor whose elements to be clipped

            consumed_inputs: legacy optimization attribute.

            max: Maximum value, above which element is replaced by max

            min: Minimum value, under which element is replaced by min
        """

        schema = get_schema("Clip", 1, "")
        op = Op(self, "Clip", schema)
        return op(
            *self._prepare_inputs(schema, input),
            consumed_inputs=consumed_inputs,
            max=max,
            min=min,
        )

    T_Concat = TypeVar("T_Concat", DOUBLE, FLOAT, FLOAT16)

    def Concat(self, *inputs: T_Concat, axis: Optional[int] = None) -> T_Concat:
        r"""[🌐 Concat(1)](https://onnx.ai/onnx/operators/onnx__Concat.html#concat-1 "Online Documentation")

        Concatenate a list of tensors into a single tensor

        Args:
            inputs: (variadic) List of tensors for concatenation

            axis: Which axis to concat on.  Default value is 1.
        """

        schema = get_schema("Concat", 1, "")
        op = Op(self, "Concat", schema)
        return op(*self._prepare_inputs(schema, *inputs), axis=axis)

    T_Constant: TypeAlias = Union[DOUBLE, FLOAT, FLOAT16]

    def Constant(self, *, value: TensorProto) -> T_Constant:
        r"""[🌐 Constant(1)](https://onnx.ai/onnx/operators/onnx__Constant.html#constant-1 "Online Documentation")

        A constant tensor.

        Args:
            value: The value for the elements of the output tensor.
        """

        schema = get_schema("Constant", 1, "")
        op = Op(self, "Constant", schema)
        return op(value=value)

    T_Conv = TypeVar("T_Conv", DOUBLE, FLOAT, FLOAT16)

    def Conv(
        self,
        X: T_Conv,
        W: T_Conv,
        B: Optional[T_Conv] = None,
        *,
        auto_pad: str = "NOTSET",
        dilations: Optional[Sequence[int]] = None,
        group: int = 1,
        kernel_shape: Optional[Sequence[int]] = None,
        pads: Optional[Sequence[int]] = None,
        strides: Optional[Sequence[int]] = None,
    ) -> T_Conv:
        r"""[🌐 Conv(1)](https://onnx.ai/onnx/operators/onnx__Conv.html#conv-1 "Online Documentation")


        The convolution operator consumes an input tensor and a filter, and
        computes the output.

        Args:
            X: Input data tensor from previous layer; has size (N x C x H x W), where N
                is the batch size, C is the number of channels, and H and W are the
                height and width. Note that this is for the 2D image. Otherwise the size
                is (N x C x D1 x D2 ... x Dn). Optionally, if dimension denotation is in
                effect, the operation expects input data tensor to arrive with the
                dimension denotation of [DATA_BATCH, DATA_CHANNEL, DATA_FEATURE,
                DATA_FEATURE ...].

            W: The weight tensor that will be used in the convolutions; has size (M x
                C/group x kH x kW), where C is the number of channels, and kH and kW are
                the height and width of the kernel, and M is the number of feature maps.
                For more than 2 dimensions, the kernel shape will be (M x C/group x k1 x
                k2 x ... x kn), where (k1 x k2 x ... kn) is the dimension of the kernel.
                Optionally, if dimension denotation is in effect, the operation expects
                the weight tensor to arrive with the dimension denotation of
                [FILTER_OUT_CHANNEL, FILTER_IN_CHANNEL, FILTER_SPATIAL, FILTER_SPATIAL
                ...]. X.shape[1] == (W.shape[1] * group) == C (assuming zero based
                indices for the shape array). Or in other words FILTER_IN_CHANNEL should
                be equal to DATA_CHANNEL.

            B: (optional) Optional 1D bias to be added to the convolution, has size of
                M.

            auto_pad: auto_pad must be either NOTSET, SAME_UPPER, SAME_LOWER or VALID.
                Where default value is NOTSET, which means explicit padding is used.
                SAME_UPPER or SAME_LOWER mean pad the input so that the output spatial
                size match the input.In case of odd number add the extra padding at the
                end for SAME_UPPER and at the beginning for SAME_LOWER. VALID mean no
                padding.

            dilations: dilation value along each spatial axis of the filter.

            group: number of groups input channels and output channels are divided into.

            kernel_shape: The shape of the convolution kernel. If not present, should be
                inferred from input W.

            pads: Padding for the beginning and ending along each spatial axis, it can
                take any value greater than or equal to 0. The value represent the
                number of pixels added to the beginning and end part of the
                corresponding axis. `pads` format should be as follow [x1_begin,
                x2_begin...x1_end, x2_end,...], where xi_begin the number of pixels
                added at the beginning of axis `i` and xi_end, the number of pixels
                added at the end of axis `i`. This attribute cannot be used
                simultaneously with auto_pad attribute. If not present, the padding
                defaults to 0 along start and end of each spatial axis.

            strides: Stride along each spatial axis.
        """

        schema = get_schema("Conv", 1, "")
        op = Op(self, "Conv", schema)
        return op(
            *self._prepare_inputs(schema, X, W, B),
            auto_pad=auto_pad,
            dilations=dilations,
            group=group,
            kernel_shape=kernel_shape,
            pads=pads,
            strides=strides,
        )

    T_ConvTranspose = TypeVar("T_ConvTranspose", DOUBLE, FLOAT, FLOAT16)

    def ConvTranspose(
        self,
        X: T_ConvTranspose,
        W: T_ConvTranspose,
        B: Optional[T_ConvTranspose] = None,
        *,
        auto_pad: str = "NOTSET",
        dilations: Optional[Sequence[int]] = None,
        group: int = 1,
        kernel_shape: Optional[Sequence[int]] = None,
        output_padding: Optional[Sequence[int]] = None,
        output_shape: Optional[Sequence[int]] = None,
        pads: Optional[Sequence[int]] = None,
        strides: Optional[Sequence[int]] = None,
    ) -> T_ConvTranspose:
        r"""[🌐 ConvTranspose(1)](https://onnx.ai/onnx/operators/onnx__ConvTranspose.html#convtranspose-1 "Online Documentation")


        The convolution transpose operator consumes an input tensor and a filter,
        and computes the output.

        If the pads parameter is provided the shape of the output is calculated via the following equation:

          output_shape[i] = stride[i] * (input_size[i] - 1) + output_padding[i] + ((kernel_shape[i] - 1) * dilations[i] + 1) - pads[start_i] - pads[end_i]

        output_shape can also be explicitly specified in which case pads values are auto generated using these equations:

          total_padding[i] = stride[i] * (input_size[i] - 1) + output_padding[i] + ((kernel_shape[i] - 1) * dilations[i] + 1) - output_shape[i]
          If (auto_pads != SAME_UPPER): pads[start_i] = total_padding[i]/2; pads[end_i] = total_padding[i] - (total_padding[i]/2)
          Else: pads[start_i] = total_padding[i] - (total_padding[i]/2); pads[end_i] = (total_padding[i]/2).



        Args:
            X: Input data tensor from previous layer; has size (N x C x H x W), where N
                is the batch size, C is the number of channels, and H and W are the
                height and width. Note that this is for the 2D image. Otherwise the size
                is (N x C x D1 x D2 ... x Dn)

            W: The weight tensor that will be used in the convolutions; has size (C x
                M/group x kH x kW), where C is the number of channels, and kH and kW are
                the height and width of the kernel, and M is the number of feature maps.
                For more than 2 dimensions, the weight shape will be (C x M/group x k1 x
                k2 x ... x kn), where (k1 x k2 x ... x kn) is the dimension of the
                kernel. The number of channels in the output should be equal to
                W.shape[1] * group (assuming zero based indices of the shape array)

            B: (optional) Optional 1D bias to be added to the convolution, has size of
                M.

            auto_pad: auto_pad must be either NOTSET, SAME_UPPER, SAME_LOWER or VALID.
                Where default value is NOTSET, which means explicit padding is used.
                SAME_UPPER or SAME_LOWER mean pad the input so that the output spatial
                size match the input.In case of odd number add the extra padding at the
                end for SAME_UPPER and at the beginning for SAME_LOWER. VALID mean no
                padding.

            dilations: dilation value along each spatial axis of the filter.

            group: number of groups input channels and output channels are divided into.

            kernel_shape: The shape of the convolution kernel. If not present, should be
                inferred from input W.

            output_padding: The zero-padding added to one side of the output. This is
                also called adjs/adjustment in some frameworks.

            output_shape: The shape of the output can be explicitly set which will cause
                pads values to be auto generated. If output_shape is specified pads
                values are ignored. See doc for details for equations to generate pads

            pads: Padding for the beginning and ending along each spatial axis, it can
                take any value greater than or equal to 0. The value represent the
                number of pixels added to the beginning and end part of the
                corresponding axis. `pads` format should be as follow [x1_begin,
                x2_begin...x1_end, x2_end,...], where xi_begin the number of pixels
                added at the beginning of axis `i` and xi_end, the number of pixels
                added at the end of axis `i`. This attribute cannot be used
                simultaneously with auto_pad attribute. If not present, the padding
                defaults to 0 along start and end of each spatial axis.

            strides: Stride along each spatial axis.
        """

        schema = get_schema("ConvTranspose", 1, "")
        op = Op(self, "ConvTranspose", schema)
        return op(
            *self._prepare_inputs(schema, X, W, B),
            auto_pad=auto_pad,
            dilations=dilations,
            group=group,
            kernel_shape=kernel_shape,
            output_padding=output_padding,
            output_shape=output_shape,
            pads=pads,
            strides=strides,
        )

    T_DepthToSpace = TypeVar(
        "T_DepthToSpace",
        BOOL,
        COMPLEX128,
        COMPLEX64,
        DOUBLE,
        FLOAT,
        FLOAT16,
        INT16,
        INT32,
        INT64,
        INT8,
        STRING,
        UINT16,
        UINT32,
        UINT64,
        UINT8,
    )

    def DepthToSpace(self, input: T_DepthToSpace, *, blocksize: int) -> T_DepthToSpace:
        r"""[🌐 DepthToSpace(1)](https://onnx.ai/onnx/operators/onnx__DepthToSpace.html#depthtospace-1 "Online Documentation")

        DepthToSpace rearranges (permutes) data from depth into blocks of spatial data.
        This is the reverse transformation of SpaceToDepth. More specifically, this op outputs a copy of
        the input tensor where values from the depth dimension are moved in spatial blocks to the height
        and width dimensions.


        Args:
            input: Input tensor of [N,C,H,W], where N is the batch axis, C is the
                channel or depth, H is the height and W is the width.

            blocksize: Blocks of [blocksize, blocksize] are moved.
        """

        schema = get_schema("DepthToSpace", 1, "")
        op = Op(self, "DepthToSpace", schema)
        return op(*self._prepare_inputs(schema, input), blocksize=blocksize)

    T_Div = TypeVar("T_Div", DOUBLE, FLOAT, FLOAT16)

    def Div(
        self,
        A: T_Div,
        B: T_Div,
        *,
        axis: Optional[int] = None,
        broadcast: int = 0,
        consumed_inputs: Optional[Sequence[int]] = None,
    ) -> T_Div:
        r"""[🌐 Div(1)](https://onnx.ai/onnx/operators/onnx__Div.html#div-1 "Online Documentation")


        Performs element-wise binary division (with limited broadcast support).

        If necessary the right-hand-side argument will be broadcasted to match the
        shape of left-hand-side argument. When broadcasting is specified, the second
        tensor can either be of element size 1 (including a scalar tensor and any
        tensor with rank equal to or smaller than the first tensor), or having its
        shape as a contiguous subset of the first tensor's shape. The starting of the
        mutually equal shape is specified by the argument "axis", and if it is not set,
        suffix matching is assumed. 1-dim expansion doesn't work yet.

        For example, the following tensor shapes are supported (with broadcast=1):

          shape(A) = (2, 3, 4, 5), shape(B) = (,), i.e. B is a scalar tensor
          shape(A) = (2, 3, 4, 5), shape(B) = (1, 1), i.e. B is an 1-element tensor
          shape(A) = (2, 3, 4, 5), shape(B) = (5,)
          shape(A) = (2, 3, 4, 5), shape(B) = (4, 5)
          shape(A) = (2, 3, 4, 5), shape(B) = (3, 4), with axis=1
          shape(A) = (2, 3, 4, 5), shape(B) = (2), with axis=0

        Attribute `broadcast=1` needs to be passed to enable broadcasting.


        Args:
            A: First operand, should share the type with the second operand.

            B: Second operand. With broadcasting can be of smaller size than A. If
                broadcasting is disabled it should be of the same size.

            axis: If set, defines the broadcast dimensions. See doc for details.

            broadcast: Pass 1 to enable broadcasting

            consumed_inputs: legacy optimization attribute.
        """

        schema = get_schema("Div", 1, "")
        op = Op(self, "Div", schema)
        return op(
            *self._prepare_inputs(schema, A, B),
            axis=axis,
            broadcast=broadcast,
            consumed_inputs=consumed_inputs,
        )

    T_Dropout = TypeVar("T_Dropout", DOUBLE, FLOAT, FLOAT16)

    def Dropout(
        self,
        data: T_Dropout,
        *,
        consumed_inputs: Optional[Sequence[int]] = None,
        is_test: int = 0,
        ratio: float = 0.5,
    ) -> Tuple[T_Dropout, T_Dropout]:
        r"""[🌐 Dropout(1)](https://onnx.ai/onnx/operators/onnx__Dropout.html#dropout-1 "Online Documentation")


        Dropout takes one input data (Tensor<float>) and produces two Tensor outputs,
        output (Tensor<float>) and mask (Tensor<bool>). Depending on whether it is in
        test mode or not, the output Y will either be a random dropout, or a simple
        copy of the input. Note that our implementation of Dropout does scaling in
        the training phase, so during testing nothing needs to be done.


        Args:
            data: The input data as Tensor.

            consumed_inputs: legacy optimization attribute.

            is_test: (int, default 0) if nonzero, run dropout in test mode where the
                output is simply Y = X.

            ratio: (float, default 0.5) the ratio of random dropout
        """

        schema = get_schema("Dropout", 1, "")
        op = Op(self, "Dropout", schema)
        return op(
            *self._prepare_inputs(schema, data),
            consumed_inputs=consumed_inputs,
            is_test=is_test,
            ratio=ratio,
        )

    T_Elu = TypeVar("T_Elu", DOUBLE, FLOAT, FLOAT16)

    def Elu(
        self, X: T_Elu, *, alpha: float = 1.0, consumed_inputs: Optional[Sequence[int]] = None
    ) -> T_Elu:
        r"""[🌐 Elu(1)](https://onnx.ai/onnx/operators/onnx__Elu.html#elu-1 "Online Documentation")


        Elu takes one input data (Tensor<T>) and produces one output data
        (Tensor<T>) where the function `f(x) = alpha * (exp(x) - 1.) for x <
        0`, `f(x) = x for x >= 0`., is applied to the tensor elementwise.



        Args:
            X: 1D input tensor

            alpha: Coefficient of ELU default to 1.0.

            consumed_inputs: legacy optimization attribute.
        """

        schema = get_schema("Elu", 1, "")
        op = Op(self, "Elu", schema)
        return op(
            *self._prepare_inputs(schema, X), alpha=alpha, consumed_inputs=consumed_inputs
        )

    T_Equal = TypeVar("T_Equal", BOOL, INT32, INT64)

    T1_Equal: TypeAlias = BOOL

    def Equal(
        self, A: T_Equal, B: T_Equal, *, axis: Optional[int] = None, broadcast: int = 0
    ) -> T1_Equal:
        r"""[🌐 Equal(1)](https://onnx.ai/onnx/operators/onnx__Equal.html#equal-1 "Online Documentation")


        Returns the tensor resulted from performing the `equal` logical operation
        elementwise on the input tensors `A` and `B`.

        If broadcasting is enabled, the right-hand-side argument will be broadcasted
        to match the shape of left-hand-side argument. See the doc of `Add` for a
        detailed description of the broadcasting rules.


        Args:
            A: Left input tensor for the logical operator.

            B: Right input tensor for the logical operator.

            axis: If set, defines the broadcast dimensions.

            broadcast: Enable broadcasting
        """

        schema = get_schema("Equal", 1, "")
        op = Op(self, "Equal", schema)
        return op(*self._prepare_inputs(schema, A, B), axis=axis, broadcast=broadcast)

    T_Exp = TypeVar("T_Exp", DOUBLE, FLOAT, FLOAT16)

    def Exp(self, input: T_Exp, *, consumed_inputs: Optional[Sequence[int]] = None) -> T_Exp:
        r"""[🌐 Exp(1)](https://onnx.ai/onnx/operators/onnx__Exp.html#exp-1 "Online Documentation")


        Calculates the exponential of the given input tensor, element-wise.


        Args:
            input: Input tensor

            consumed_inputs: legacy optimization attribute.
        """

        schema = get_schema("Exp", 1, "")
        op = Op(self, "Exp", schema)
        return op(*self._prepare_inputs(schema, input), consumed_inputs=consumed_inputs)

    T_Flatten = TypeVar("T_Flatten", DOUBLE, FLOAT, FLOAT16)

    def Flatten(self, input: T_Flatten, *, axis: int = 1) -> T_Flatten:
        r"""[🌐 Flatten(1)](https://onnx.ai/onnx/operators/onnx__Flatten.html#flatten-1 "Online Documentation")


        Flattens the input tensor into a 2D matrix. If input tensor has shape
        (d_0, d_1, ... d_n) then the output will have shape
        (d_0 X d_1 ... d_(axis-1), d_axis X d_(axis+1) ... X dn).


        Args:
            input: A tensor of rank >= axis.

            axis: Indicate up to which input dimensions (exclusive) should be flattened
                to the outer dimension of the output. The value for axis must be in the
                range [0, R], where R is the rank of the input tensor. When axis = 0,
                the shape of the output tensor is (1, (d_0 X d_1 ... d_n), where the
                shape of the input tensor is (d_0, d_1, ... d_n).
        """

        schema = get_schema("Flatten", 1, "")
        op = Op(self, "Flatten", schema)
        return op(*self._prepare_inputs(schema, input), axis=axis)

    T_Floor = TypeVar("T_Floor", DOUBLE, FLOAT, FLOAT16)

    def Floor(self, X: T_Floor, *, consumed_inputs: Optional[Sequence[int]] = None) -> T_Floor:
        r"""[🌐 Floor(1)](https://onnx.ai/onnx/operators/onnx__Floor.html#floor-1 "Online Documentation")


        Floor takes one input data (Tensor<T>) and produces one output data
        (Tensor<T>) where the floor is, y = floor(x), is applied to
        the tensor elementwise.


        Args:
            X: Input tensor

            consumed_inputs: legacy optimization attribute.
        """

        schema = get_schema("Floor", 1, "")
        op = Op(self, "Floor", schema)
        return op(*self._prepare_inputs(schema, X), consumed_inputs=consumed_inputs)

    T_GRU = TypeVar("T_GRU", DOUBLE, FLOAT, FLOAT16)

    T1_GRU: TypeAlias = INT32

    def GRU(
        self,
        X: T_GRU,
        W: T_GRU,
        R: T_GRU,
        B: Optional[T_GRU] = None,
        sequence_lens: Optional[T1_GRU] = None,
        initial_h: Optional[T_GRU] = None,
        *,
        activation_alpha: Optional[Sequence[float]] = None,
        activation_beta: Optional[Sequence[float]] = None,
        activations: Optional[Sequence[str]] = None,
        clip: Optional[float] = None,
        direction: str = "foward",
        hidden_size: Optional[int] = None,
        output_sequence: int = 0,
    ) -> Tuple[T_GRU, T_GRU]:
        r"""[🌐 GRU(1)](https://onnx.ai/onnx/operators/onnx__GRU.html#gru-1 "Online Documentation")


        Computes an one-layer GRU. This operator is usually supported via some custom
        implementation such as CuDNN.

        Notations:

        `X` - input tensor

        `z` - update gate

        `r` - reset gate

        `h` - hidden gate

        `t` - time step (t-1 means previous time step)

        `W[zrh]` - W parameter weight matrix for update, reset, and hidden gates

        `R[zrh]` - R recurrence weight matrix for update, reset, and hidden gates

        `Wb[zrh]` - W bias vectors for update, reset, and hidden gates

        `Rb[zrh]` - R bias vectors for update, reset, and hidden gates

        `WB[zrh]` - W parameter weight matrix for backward update, reset, and hidden gates

        `RB[zrh]` - R recurrence weight matrix for backward update, reset, and hidden gates

        `WBb[zrh]` - W bias vectors for backward update, reset, and hidden gates

        `RBb[zrh]` - R bias vectors for backward update, reset, and hidden gates

        `H` - Hidden state

        `num_directions` - 2 if direction == bidirectional else 1

        Activation functions:

          Relu(x)                - max(0, x)

          Tanh(x)                - (1 - e^{-2x})/(1 + e^{-2x})

          Sigmoid(x)             - 1/(1 + e^{-x})

          (NOTE: Below are optional)

          Affine(x)              - alpha*x + beta

          LeakyRelu(x)           - x if x >= 0 else alpha * x

          ThresholdedRelu(x)     - x if x >= alpha else 0

          ScaledTanh(x)          - alpha*Tanh(beta*x)

          HardSigmoid(x)         - min(max(alpha*x + beta, 0), 1)

          Elu(x)                 - x if x >= 0 else alpha*(e^x - 1)

          Softsign(x)            - x/(1 + |x|)

          Softplus(x)            - log(1 + e^x)

        Equations (Default: f=Sigmoid, g=Tanh):

          - zt = f(Xt*(Wz^T) + Ht-1*Rz + Wbz + Rbz)

          - rt = f(Xt*(Wr^T) + Ht-1*Rr + Wbr + Rbr)

          - ht = g(Xt*(Wh^T) + (rt (.) Ht-1)*Rh + Rbh + Wbh) # default, when linear_before_reset = 0

          - ht = g(Xt*(Wh^T) + (rt (.) (Ht-1*Rh + Rbh) + Wbh) # when linear_before_reset != 0

          - Ht = (1 - zt) (.) ht + zt (.) Ht-1


        Args:
            X: The input sequences packed (and potentially padded) into one 3-D tensor
                with the shape of `[seq_length, batch_size, input_size]`.

            W: The weight tensor for the gates. Concatenation of `W[zrh]` and `WB[zrh]`
                (if bidirectional) along dimension 0. This tensor has shape
                `[num_directions, 3*hidden_size, input_size]`.

            R: The recurrence weight tensor. Concatenation of `R[zrh]` and `RB[zrh]` (if
                bidirectional) along dimension 0. This tensor has shape
                `[num_directions, 3*hidden_size, hidden_size]`.

            B: (optional) The bias tensor for the gates. Concatenation of `[Wb[zrh],
                Rb[zrh]]` and `[WBb[zrh], RBb[zrh]]` (if bidirectional) along dimension
                0. This tensor has shape `[num_directions, 6*hidden_size]`. Optional: If
                not specified - assumed to be 0

            sequence_lens: (optional) Optional tensor specifying lengths of the
                sequences in a batch. If not specified - assumed all sequences in the
                batch to have length `seq_length`. It has shape `[batch_size]`.

            initial_h: (optional) Optional initial value of the hidden. If not specified
                - assumed to be 0. It has shape `[num_directions, batch_size,
                hidden_size]`.

            activation_alpha: Optional scaling values used by some activation functions.
                The values are consumed in the order of activation functions, for
                example (f, g, h) in LSTM.

            activation_beta: Optional scaling values used by some activation functions.
                The values are consumed in the order of activation functions, for
                example (f, g, h) in LSTM.

            activations: A list of 2 (or 4 if bidirectional) activation functions for
                update, reset, and hidden gates. The activation functions must be one of
                the activation functions specified above. Optional: See the equations
                for default if not specified.

            clip: Cell clip threshold. Clipping bounds the elements of a tensor in the
                range of [-threshold, +threshold] and is applied to the input of
                activations. No clip if not specified.

            direction: Specify if the RNN is forward, reverse, or bidirectional. Must be
                one of forward (default), reverse, or bidirectional.

            hidden_size: Number of neurons in the hidden layer

            output_sequence: The sequence output for the hidden is optional if 0.
                Default 0.
        """

        schema = get_schema("GRU", 1, "")
        op = Op(self, "GRU", schema)
        return op(
            *self._prepare_inputs(schema, X, W, R, B, sequence_lens, initial_h),
            activation_alpha=activation_alpha,
            activation_beta=activation_beta,
            activations=activations,
            clip=clip,
            direction=direction,
            hidden_size=hidden_size,
            output_sequence=output_sequence,
        )

    T_Gather = TypeVar(
        "T_Gather",
        BOOL,
        COMPLEX128,
        COMPLEX64,
        DOUBLE,
        FLOAT,
        FLOAT16,
        INT16,
        INT32,
        INT64,
        INT8,
        STRING,
        UINT16,
        UINT32,
        UINT64,
        UINT8,
    )

    Tind_Gather = TypeVar("Tind_Gather", INT32, INT64)

    def Gather(self, data: T_Gather, indices: Tind_Gather, *, axis: int = 0) -> T_Gather:
        r"""[🌐 Gather(1)](https://onnx.ai/onnx/operators/onnx__Gather.html#gather-1 "Online Documentation")


        Given `data` tensor of rank r >= 1, and `indices` tensor of rank q, gather
        entries of the axis dimension of `data` (by default outer-most one as axis=0) indexed by `indices`, and concatenates
        them in an output tensor of rank q + (r - 1).
        Example 1:
        ::

              data = [
                  [1.0, 1.2],
                  [2.3, 3.4],
                  [4.5, 5.7],
              ]
              indices = [
                  [0, 1],
                  [1, 2],
              ]
              output = [
                  [
                      [1.0, 1.2],
                      [2.3, 3.4],
                  ],
                  [
                      [2.3, 3.4],
                      [4.5, 5.7],
                  ],
              ]


        Example 2:
        ::

              data = [
                  [1.0, 1.2, 1.9],
                  [2.3, 3.4, 3.9],
                  [4.5, 5.7, 5.9],
              ]
              indices = [
                  [0, 2],
              ]
              axis = 1,
              output = [
                  [[1.0, 1.9]],
                  [[2.3, 3.9]],
                  [[4.5, 5.9]],
              ]




        Args:
            data: Tensor of rank r >= 1.

            indices: Tensor of int32/int64 indices, of any rank q. All index values are
                expected to be within bounds. It is an error if any of the index values
                are out of bounds.

            axis: Which axis to gather on. Negative value means counting dimensions from
                the back. Accepted range is [-r, r-1]
        """

        schema = get_schema("Gather", 1, "")
        op = Op(self, "Gather", schema)
        return op(*self._prepare_inputs(schema, data, indices), axis=axis)

    T_Gemm = TypeVar("T_Gemm", DOUBLE, FLOAT, FLOAT16)

    def Gemm(
        self,
        A: T_Gemm,
        B: T_Gemm,
        C: T_Gemm,
        *,
        alpha: float = 1.0,
        beta: float = 1.0,
        broadcast: int = 0,
        transA: int = 0,
        transB: int = 0,
    ) -> T_Gemm:
        r"""[🌐 Gemm(1)](https://onnx.ai/onnx/operators/onnx__Gemm.html#gemm-1 "Online Documentation")

        General Matrix multiplication:
        https://en.wikipedia.org/wiki/Basic_Linear_Algebra_Subprograms#Level_3
        Compute Y = alpha * A * B + beta * C, where input tensor A has
        dimension (M X K), input tensor B has dimension (K X N), input tensor C and
        output tensor Y have dimension (M X N).
        If attribute broadcast is non-zero, input tensor C will be broadcasted to match
        the dimension requirement. A will be transposed before doing the computation
        if attribute transA is non-zero, same for B and transB.


        Args:
            A: Input tensor A

            B: Input tensor B

            C: Input tensor C, can be inplace.

            alpha: Scalar multiplier for the product of input tensors A * B, the default
                value is 1.0.

            beta: Scalar multiplier for input tensor C, the default value is 1.0.

            broadcast: Whether C should be broadcasted

            transA: Whether A should be transposed

            transB: Whether B should be transposed
        """

        schema = get_schema("Gemm", 1, "")
        op = Op(self, "Gemm", schema)
        return op(
            *self._prepare_inputs(schema, A, B, C),
            alpha=alpha,
            beta=beta,
            broadcast=broadcast,
            transA=transA,
            transB=transB,
        )

    T_GlobalAveragePool = TypeVar("T_GlobalAveragePool", DOUBLE, FLOAT, FLOAT16)

    def GlobalAveragePool(self, X: T_GlobalAveragePool) -> T_GlobalAveragePool:
        r"""[🌐 GlobalAveragePool(1)](https://onnx.ai/onnx/operators/onnx__GlobalAveragePool.html#globalaveragepool-1 "Online Documentation")


         GlobalAveragePool consumes an input tensor X and applies average pooling across
         the values in the same channel. This is equivalent to AveragePool with kernel size
         equal to the spatial dimension of input tensor.

        Args:
            X: (differentiable) Input data tensor from the previous operator; dimensions
                for image case are (N x C x H x W), where N is the batch size, C is the
                number of channels, and H and W are the height and the width of the
                data. For non image case, the dimensions are in the form of (N x C x D1
                x D2 ... Dn), where N is the batch size.
        """

        schema = get_schema("GlobalAveragePool", 1, "")
        op = Op(self, "GlobalAveragePool", schema)
        return op(*self._prepare_inputs(schema, X))

    T_GlobalLpPool = TypeVar("T_GlobalLpPool", DOUBLE, FLOAT, FLOAT16)

    def GlobalLpPool(self, X: T_GlobalLpPool, *, p: float = 2.0) -> T_GlobalLpPool:
        r"""[🌐 GlobalLpPool(1)](https://onnx.ai/onnx/operators/onnx__GlobalLpPool.html#globallppool-1 "Online Documentation")


         GlobalLpPool consumes an input tensor X and applies lp pool pooling across the
         the values in the same channel. This is equivalent to LpPool with kernel size
         equal to the spatial dimension of input tensor.

        Args:
            X: Input data tensor from the previous operator; dimensions for image case
                are (N x C x H x W), where N is the batch size, C is the number of
                channels, and H and W are the height and the width of the data. For non
                image case, the dimension are in the form of (N x C x D1 x D2 ... Dn),
                where N is the batch size.

            p: p value of the Lp norm used to pool over the input data, default is 2.0.
        """

        schema = get_schema("GlobalLpPool", 1, "")
        op = Op(self, "GlobalLpPool", schema)
        return op(*self._prepare_inputs(schema, X), p=p)

    T_GlobalMaxPool = TypeVar("T_GlobalMaxPool", DOUBLE, FLOAT, FLOAT16)

    def GlobalMaxPool(self, X: T_GlobalMaxPool) -> T_GlobalMaxPool:
        r"""[🌐 GlobalMaxPool(1)](https://onnx.ai/onnx/operators/onnx__GlobalMaxPool.html#globalmaxpool-1 "Online Documentation")


         GlobalMaxPool consumes an input tensor X and applies max pooling across
         the values in the same channel. This is equivalent to MaxPool with kernel size
         equal to the spatial dimension of input tensor.

        Args:
            X: (differentiable) Input data tensor from the previous operator; dimensions
                for image case are (N x C x H x W), where N is the batch size, C is the
                number of channels, and H and W are the height and the width of the
                data. For non image case, the dimensions are in the form of (N x C x D1
                x D2 ... Dn), where N is the batch size.
        """

        schema = get_schema("GlobalMaxPool", 1, "")
        op = Op(self, "GlobalMaxPool", schema)
        return op(*self._prepare_inputs(schema, X))

    T_Greater = TypeVar("T_Greater", DOUBLE, FLOAT, FLOAT16)

    T1_Greater: TypeAlias = BOOL

    def Greater(
        self, A: T_Greater, B: T_Greater, *, axis: Optional[int] = None, broadcast: int = 0
    ) -> T1_Greater:
        r"""[🌐 Greater(1)](https://onnx.ai/onnx/operators/onnx__Greater.html#greater-1 "Online Documentation")


        Returns the tensor resulted from performing the `greater` logical operation
        elementwise on the input tensors `A` and `B`.

        If broadcasting is enabled, the right-hand-side argument will be broadcasted
        to match the shape of left-hand-side argument. See the doc of `Add` for a
        detailed description of the broadcasting rules.


        Args:
            A: Left input tensor for the logical operator.

            B: Right input tensor for the logical operator.

            axis: If set, defines the broadcast dimensions.

            broadcast: Enable broadcasting
        """

        schema = get_schema("Greater", 1, "")
        op = Op(self, "Greater", schema)
        return op(*self._prepare_inputs(schema, A, B), axis=axis, broadcast=broadcast)

    T_HardSigmoid = TypeVar("T_HardSigmoid", DOUBLE, FLOAT, FLOAT16)

    def HardSigmoid(
        self,
        X: T_HardSigmoid,
        *,
        alpha: float = 0.20000000298023224,
        beta: float = 0.5,
        consumed_inputs: Optional[Sequence[int]] = None,
    ) -> T_HardSigmoid:
        r"""[🌐 HardSigmoid(1)](https://onnx.ai/onnx/operators/onnx__HardSigmoid.html#hardsigmoid-1 "Online Documentation")


        HardSigmoid takes one input data (Tensor<T>) and produces one output data
        (Tensor<T>) where the HardSigmoid function, y = max(0, min(1, alpha * x + beta)),
        is applied to the tensor elementwise.


        Args:
            X: Input tensor

            alpha: Value of alpha default to 0.2

            beta: Value of beta default to 0.5

            consumed_inputs: legacy optimization attribute.
        """

        schema = get_schema("HardSigmoid", 1, "")
        op = Op(self, "HardSigmoid", schema)
        return op(
            *self._prepare_inputs(schema, X),
            alpha=alpha,
            beta=beta,
            consumed_inputs=consumed_inputs,
        )

    T_Hardmax = TypeVar("T_Hardmax", DOUBLE, FLOAT, FLOAT16)

    def Hardmax(self, input: T_Hardmax, *, axis: int = 1) -> T_Hardmax:
        r"""[🌐 Hardmax(1)](https://onnx.ai/onnx/operators/onnx__Hardmax.html#hardmax-1 "Online Documentation")


        The operator computes the hardmax (1 for the first maximum value, and 0 for all others) values for each layer in the batch
         of the given input. The input is a 2-D tensor (Tensor<float>) of size
        (batch_size x input_feature_dimensions). The output tensor has the same shape
        and contains the hardmax values of the corresponding input.

        Input does not need to explicitly be a 2D vector; rather, it will be
        coerced into one. For an arbitrary n-dimensional tensor
        input \in [a_0, a_1, ..., a_{k-1}, a_k, ..., a_{n-1}] and k is
        the axis provided, then input will be coerced into a 2-dimensional tensor with
        dimensions [a_0 * ... * a_{k-1}, a_k * ... * a_{n-1}]. For the default
        case where axis=1, this means the input tensor will be coerced into a 2D tensor
        of dimensions [a_0, a_1 * ... * a_{n-1}], where a_0 is often the batch size.
        In this situation, we must have a_0 = N and a_1 * ... * a_{n-1} = D.
        Each of these dimensions must be matched correctly, or else the operator
        will throw errors.


        Args:
            input: The input tensor that's coerced into a 2D matrix of size (NxD) as
                described above.

            axis: Describes the axis of the inputs when coerced to 2D; defaults to one
                because the 0th axis most likely describes the batch_size
        """

        schema = get_schema("Hardmax", 1, "")
        op = Op(self, "Hardmax", schema)
        return op(*self._prepare_inputs(schema, input), axis=axis)

    T_Identity = TypeVar(
        "T_Identity",
        BOOL,
        COMPLEX128,
        COMPLEX64,
        DOUBLE,
        FLOAT,
        FLOAT16,
        INT16,
        INT32,
        INT64,
        INT8,
        STRING,
        UINT16,
        UINT32,
        UINT64,
        UINT8,
    )

    def Identity(self, input: T_Identity) -> T_Identity:
        r"""[🌐 Identity(1)](https://onnx.ai/onnx/operators/onnx__Identity.html#identity-1 "Online Documentation")

        Identity operator

        Args:
            input: Input tensor
        """

        schema = get_schema("Identity", 1, "")
        op = Op(self, "Identity", schema)
        return op(*self._prepare_inputs(schema, input))

    B_If: TypeAlias = BOOL

    V_If: TypeAlias = Union[
        BOOL,
        COMPLEX128,
        COMPLEX64,
        DOUBLE,
        FLOAT,
        FLOAT16,
        INT16,
        INT32,
        INT64,
        INT8,
        STRING,
        UINT16,
        UINT32,
        UINT64,
        UINT8,
    ]

    def If(self, cond: B_If, *, else_branch: GraphProto, then_branch: GraphProto) -> V_If:
        r"""[🌐 If(1)](https://onnx.ai/onnx/operators/onnx__If.html#if-1 "Online Documentation")

        If conditional

        Args:
            cond: Condition for the if. The tensor must contain a single element.

            else_branch: Graph to run if condition is false. Has N outputs: values you
                wish to be live-out to the enclosing scope. The number of outputs must
                match the number of outputs in the then_branch.

            then_branch: Graph to run if condition is true. Has N outputs: values you
                wish to be live-out to the enclosing scope. The number of outputs must
                match the number of outputs in the else_branch.
        """

        schema = get_schema("If", 1, "")
        op = Op(self, "If", schema)
        return op(
            *self._prepare_inputs(schema, cond),
            else_branch=else_branch,
            then_branch=then_branch,
        )

    T_InstanceNormalization = TypeVar("T_InstanceNormalization", DOUBLE, FLOAT, FLOAT16)

    def InstanceNormalization(
        self,
        input: T_InstanceNormalization,
        scale: T_InstanceNormalization,
        B: T_InstanceNormalization,
        *,
        consumed_inputs: Optional[Sequence[int]] = None,
        epsilon: float = 9.999999747378752e-06,
    ) -> T_InstanceNormalization:
        r"""[🌐 InstanceNormalization(1)](https://onnx.ai/onnx/operators/onnx__InstanceNormalization.html#instancenormalization-1 "Online Documentation")


        Carries out instance normalization as described in the paper
        https://arxiv.org/abs/1607.08022.

        y = scale * (x - mean) / sqrt(variance + epsilon) + B,
        where mean and variance are computed per instance per channel.



        Args:
            input: The input 4-dimensional tensor of shape NCHW.

            scale: The input 1-dimensional scale tensor of size C.

            B: The input 1-dimensional bias tensor of size C.

            consumed_inputs: legacy optimization attribute.

            epsilon: The epsilon value to use to avoid division by zero, default is
                1e-5f.
        """

        schema = get_schema("InstanceNormalization", 1, "")
        op = Op(self, "InstanceNormalization", schema)
        return op(
            *self._prepare_inputs(schema, input, scale, B),
            consumed_inputs=consumed_inputs,
            epsilon=epsilon,
        )

    T_LRN = TypeVar("T_LRN", DOUBLE, FLOAT, FLOAT16)

    def LRN(
        self,
        X: T_LRN,
        *,
        alpha: float = 9.999999747378752e-05,
        beta: float = 0.75,
        bias: float = 1.0,
        size: int,
    ) -> T_LRN:
        r"""[🌐 LRN(1)](https://onnx.ai/onnx/operators/onnx__LRN.html#lrn-1 "Online Documentation")


        Local Response Normalization proposed in the [AlexNet paper](https://papers.nips.cc/paper/4824-imagenet-classification-with-deep-convolutional-neural-networks.pdf).
        It normalizes over local input regions.
        The local region is defined across the channels. For an element X[n, c, d1, ..., dk] in a tensor
        of shape (N x C x D1 x D2, ..., Dk), its region is
        {X[n, i, d1, ..., dk] | max(0, c - floor((size - 1) / 2)) <= i <= min(C - 1, c + ceil((size - 1) / 2))}.

        square_sum[n, c, d1, ..., dk] = sum(X[n, i, d1, ..., dk] ^ 2),
        where max(0, c - floor((size - 1) / 2)) <= i <= min(C - 1, c + ceil((size - 1) / 2)).

        Y[n, c, d1, ..., dk] = X[n, c, d1, ..., dk] / (bias + alpha / size * square_sum[n, c, d1, ..., dk] ) ^ beta


        Args:
            X: Input data tensor from the previous operator; dimensions for image case
                are (N x C x H x W), where N is the batch size, C is the number of
                channels, and H and W are the height and the width of the data. For non
                image case, the dimensions are in the form of (N x C x D1 x D2 ... Dn),
                where N is the batch size. Optionally, if dimension denotation is in
                effect, the operation expects the input data tensor to arrive with the
                dimension denotation of [DATA_BATCH, DATA_CHANNEL, DATA_FEATURE,
                DATA_FEATURE ...].

            alpha: Scaling parameter.

            beta: The exponent.

            size: The number of channels to sum over
        """

        schema = get_schema("LRN", 1, "")
        op = Op(self, "LRN", schema)
        return op(
            *self._prepare_inputs(schema, X), alpha=alpha, beta=beta, bias=bias, size=size
        )

    T_LSTM = TypeVar("T_LSTM", DOUBLE, FLOAT, FLOAT16)

    T1_LSTM: TypeAlias = INT32

    def LSTM(
        self,
        X: T_LSTM,
        W: T_LSTM,
        R: T_LSTM,
        B: Optional[T_LSTM] = None,
        sequence_lens: Optional[T1_LSTM] = None,
        initial_h: Optional[T_LSTM] = None,
        initial_c: Optional[T_LSTM] = None,
        P: Optional[T_LSTM] = None,
        *,
        activation_alpha: Optional[Sequence[float]] = None,
        activation_beta: Optional[Sequence[float]] = None,
        activations: Optional[Sequence[str]] = None,
        clip: Optional[float] = None,
        direction: str = "forward",
        hidden_size: Optional[int] = None,
        input_forget: int = 0,
        output_sequence: int = 0,
    ) -> Tuple[T_LSTM, T_LSTM, T_LSTM]:
        r"""[🌐 LSTM(1)](https://onnx.ai/onnx/operators/onnx__LSTM.html#lstm-1 "Online Documentation")


        Computes an one-layer LSTM. This operator is usually supported via some
        custom implementation such as CuDNN.

        Notations:

        `X` - input tensor

        `i` - input gate

        `o` - output gate

        `f` - forget gate

        `c` - cell gate

        `t` - time step (t-1 means previous time step)

        `W[iofc]` - W parameter weight matrix for input, output, forget, and cell gates

        `R[iofc]` - R recurrence weight matrix for input, output, forget, and cell gates

        `Wb[iofc]` - W bias vectors for input, output, forget, and cell gates

        `Rb[iofc]` - R bias vectors for input, output, forget, and cell gates

        `P[iof]`  - P peephole weight vector for input, output, and forget gates

        `WB[iofc]` - W parameter weight matrix for backward input, output, forget, and cell gates

        `RB[iofc]` - R recurrence weight matrix for backward input, output, forget, and cell gates

        `WBb[iofc]` - W bias vectors for backward input, output, forget, and cell gates

        `RBb[iofc]` - R bias vectors for backward input, output, forget, and cell gates

        `PB[iof]`  - P peephole weight vector for backward input, output, and forget gates

        `H` - Hidden state

        `num_directions` - 2 if direction == bidirectional else 1

        Activation functions:

          Relu(x)                - max(0, x)

          Tanh(x)                - (1 - e^{-2x})/(1 + e^{-2x})

          Sigmoid(x)             - 1/(1 + e^{-x})

          (NOTE: Below are optional)

          Affine(x)              - alpha*x + beta

          LeakyRelu(x)           - x if x >= 0 else alpha * x

          ThresholdedRelu(x)     - x if x >= alpha else 0

          ScaledTanh(x)          - alpha*Tanh(beta*x)

          HardSigmoid(x)         - min(max(alpha*x + beta, 0), 1)

          Elu(x)                 - x if x >= 0 else alpha*(e^x - 1)

          Softsign(x)            - x/(1 + |x|)

          Softplus(x)            - log(1 + e^x)

        Equations (Default: f=Sigmoid, g=Tanh, h=Tanh):

          - it = f(Xt*(Wi^T) + Ht-1*Ri + Pi (.) Ct-1 + Wbi + Rbi)

          - ft = f(Xt*(Wf^T) + Ht-1*Rf + Pf (.) Ct-1 + Wbf + Rbf)

          - ct = g(Xt*(Wc^T) + Ht-1*Rc + Wbc + Rbc)

          - Ct = ft (.) Ct-1 + it (.) ct

          - ot = f(Xt*(Wo^T) + Ht-1*Ro + Po (.) Ct + Wbo + Rbo)

          - Ht = ot (.) h(Ct)


        Args:
            X: The input sequences packed (and potentially padded) into one 3-D tensor
                with the shape of `[seq_length, batch_size, input_size]`.

            W: The weight tensor for the gates. Concatenation of `W[iofc]` and
                `WB[iofc]` (if bidirectional) along dimension 0. The tensor has shape
                `[num_directions, 4*hidden_size, input_size]`.

            R: The recurrence weight tensor. Concatenation of `R[iofc]` and `RB[iofc]`
                (if bidirectional) along dimension 0. This tensor has shape
                `[num_directions, 4*hidden_size, hidden_size]`.

            B: (optional) The bias tensor for input gate. Concatenation of `[Wb[iofc],
                Rb[iofc]]`, and `[WBb[iofc], RBb[iofc]]` (if bidirectional) along
                dimension 0. This tensor has shape `[num_directions, 8*hidden_size]`.
                Optional: If not specified - assumed to be 0.

            sequence_lens: (optional) Optional tensor specifying lengths of the
                sequences in a batch. If not specified - assumed all sequences in the
                batch to have length `seq_length`. It has shape `[batch_size]`.

            initial_h: (optional) Optional initial value of the hidden. If not specified
                - assumed to be 0. It has shape `[num_directions, batch_size,
                hidden_size]`.

            initial_c: (optional) Optional initial value of the cell. If not specified -
                assumed to be 0. It has shape `[num_directions, batch_size,
                hidden_size]`.

            P: (optional) The weight tensor for peepholes. Concatenation of `P[iof]` and
                `PB[iof]` (if bidirectional) along dimension 0. It has shape
                `[num_directions, 3*hidde_size]`. Optional: If not specified - assumed
                to be 0.

            activation_alpha: Optional scaling values used by some activation functions.
                The values are consumed in the order of activation functions, for
                example (f, g, h) in LSTM. Default values are the same as of
                corresponding ONNX operators.For example with LeakyRelu, the default
                alpha is 0.01.

            activation_beta: Optional scaling values used by some activation functions.
                The values are consumed in the order of activation functions, for
                example (f, g, h) in LSTM. Default values are the same as of
                corresponding ONNX operators.

            activations: A list of 3 (or 6 if bidirectional) activation functions for
                input, output, forget, cell, and hidden. The activation functions must
                be one of the activation functions specified above. Optional: See the
                equations for default if not specified.

            clip: Cell clip threshold. Clipping bounds the elements of a tensor in the
                range of [-threshold, +threshold] and is applied to the input of
                activations. No clip if not specified.

            direction: Specify if the RNN is forward, reverse, or bidirectional. Must be
                one of forward (default), reverse, or bidirectional.

            hidden_size: Number of neurons in the hidden layer

            input_forget: Couple the input and forget gates if 1, default 0.

            output_sequence: The sequence output for the hidden is optional if 0.
                Default 0.
        """

        schema = get_schema("LSTM", 1, "")
        op = Op(self, "LSTM", schema)
        return op(
            *self._prepare_inputs(schema, X, W, R, B, sequence_lens, initial_h, initial_c, P),
            activation_alpha=activation_alpha,
            activation_beta=activation_beta,
            activations=activations,
            clip=clip,
            direction=direction,
            hidden_size=hidden_size,
            input_forget=input_forget,
            output_sequence=output_sequence,
        )

    T_LeakyRelu = TypeVar("T_LeakyRelu", DOUBLE, FLOAT, FLOAT16)

    def LeakyRelu(
        self,
        X: T_LeakyRelu,
        *,
        alpha: float = 0.009999999776482582,
        consumed_inputs: Optional[Sequence[int]] = None,
    ) -> T_LeakyRelu:
        r"""[🌐 LeakyRelu(1)](https://onnx.ai/onnx/operators/onnx__LeakyRelu.html#leakyrelu-1 "Online Documentation")


        LeakyRelu takes input data (Tensor<T>) and an argument alpha, and produces one
        output data (Tensor<T>) where the function `f(x) = alpha * x for x < 0`,
        `f(x) = x for x >= 0`, is applied to the data tensor elementwise.


        Args:
            X: Input tensor

            alpha: Coefficient of leakage default to 0.01.

            consumed_inputs: legacy optimization attribute.
        """

        schema = get_schema("LeakyRelu", 1, "")
        op = Op(self, "LeakyRelu", schema)
        return op(
            *self._prepare_inputs(schema, X), alpha=alpha, consumed_inputs=consumed_inputs
        )

    T_Less = TypeVar("T_Less", DOUBLE, FLOAT, FLOAT16)

    T1_Less: TypeAlias = BOOL

    def Less(
        self, A: T_Less, B: T_Less, *, axis: Optional[int] = None, broadcast: int = 0
    ) -> T1_Less:
        r"""[🌐 Less(1)](https://onnx.ai/onnx/operators/onnx__Less.html#less-1 "Online Documentation")


        Returns the tensor resulted from performing the `less` logical operation
        elementwise on the input tensors `A` and `B`.

        If broadcasting is enabled, the right-hand-side argument will be broadcasted
        to match the shape of left-hand-side argument. See the doc of `Add` for a
        detailed description of the broadcasting rules.


        Args:
            A: Left input tensor for the logical operator.

            B: Right input tensor for the logical operator.

            axis: If set, defines the broadcast dimensions.

            broadcast: Enable broadcasting
        """

        schema = get_schema("Less", 1, "")
        op = Op(self, "Less", schema)
        return op(*self._prepare_inputs(schema, A, B), axis=axis, broadcast=broadcast)

    T_Log = TypeVar("T_Log", DOUBLE, FLOAT, FLOAT16)

    def Log(self, input: T_Log, *, consumed_inputs: Optional[Sequence[int]] = None) -> T_Log:
        r"""[🌐 Log(1)](https://onnx.ai/onnx/operators/onnx__Log.html#log-1 "Online Documentation")


        Calculates the natural log of the given input tensor, element-wise.


        Args:
            input: Input tensor

            consumed_inputs: legacy optimization attribute.
        """

        schema = get_schema("Log", 1, "")
        op = Op(self, "Log", schema)
        return op(*self._prepare_inputs(schema, input), consumed_inputs=consumed_inputs)

    T_LogSoftmax = TypeVar("T_LogSoftmax", DOUBLE, FLOAT, FLOAT16)

    def LogSoftmax(self, input: T_LogSoftmax, *, axis: int = 1) -> T_LogSoftmax:
        r"""[🌐 LogSoftmax(1)](https://onnx.ai/onnx/operators/onnx__LogSoftmax.html#logsoftmax-1 "Online Documentation")


        The operator computes the logsoftmax (log of softmax) values for each layer in the batch
         of the given input. The input is a 2-D tensor (Tensor<float>) of size
        (batch_size x input_feature_dimensions). The output tensor has the same shape
        and contains the logsoftmax values of the corresponding input.

        Input does not need to explicitly be a 2D vector; rather, it will be
        coerced into one. For an arbitrary n-dimensional tensor
        input \in [a_0, a_1, ..., a_{k-1}, a_k, ..., a_{n-1}] and k is
        the axis provided, then input will be coerced into a 2-dimensional tensor with
        dimensions [a_0 * ... * a_{k-1}, a_k * ... * a_{n-1}]. For the default
        case where axis=1, this means the input tensor will be coerced into a 2D tensor
        of dimensions [a_0, a_1 * ... * a_{n-1}], where a_0 is often the batch size.
        In this situation, we must have a_0 = N and a_1 * ... * a_{n-1} = D.
        Each of these dimensions must be matched correctly, or else the operator
        will throw errors.


        Args:
            input: The input tensor that's coerced into a 2D matrix of size (NxD) as
                described above.

            axis: Describes the axis of the inputs when coerced to 2D; defaults to one
                because the 0th axis most likely describes the batch_size
        """

        schema = get_schema("LogSoftmax", 1, "")
        op = Op(self, "LogSoftmax", schema)
        return op(*self._prepare_inputs(schema, input), axis=axis)

    I_Loop: TypeAlias = INT64

    B_Loop: TypeAlias = BOOL

    V_Loop = TypeVar(
        "V_Loop",
        BOOL,
        COMPLEX128,
        COMPLEX64,
        DOUBLE,
        FLOAT,
        FLOAT16,
        INT16,
        INT32,
        INT64,
        INT8,
        STRING,
        UINT16,
        UINT32,
        UINT64,
        UINT8,
    )

    def Loop(
        self, M: Optional[I_Loop], cond: Optional[B_Loop], *v_initial: V_Loop, body: GraphProto
    ) -> V_Loop:
        r"""[🌐 Loop(1)](https://onnx.ai/onnx/operators/onnx__Loop.html#loop-1 "Online Documentation")


        Generic Looping construct. This loop has multiple termination conditions:

        1) Trip count. Iteration count specified at runtime. Set by
           specifying the input M. Optional. Set to empty string to omit.
           Note that a static trip count (specified at graph construction time) can be
           specified by passing in a constant node for input M.
        2) Loop termination condition. This is an input to the op that determines
           whether to run the first iteration and also a loop-carried dependency for
           the body graph. The body graph must yield a value for the condition variable,
           whether this input is provided or not.

        This table summarizes the operating modes of this operator with equivalent
        C-style code:

            Operator inputs defined as (max_trip_count, condition_var).

            input ("", ""):
                for (int i=0; ; ++i) {
                  cond = ... // Note this value is ignored, but is required in the body
                }

            input ("", cond) // Note this is analogous to a while loop
                bool cond = ...;
                for (int i=0; cond; ++i) {
                  cond = ...;
                }

            input ("", 1) // Note this is analogous to a do-while loop
                bool cond = true
                for (int i=0; cond; ++i) {
                  cond = ...;
                }

            input (trip_count, "") // Note this is analogous to a for loop
                int trip_count = ...
                for (int i=0; i < trip_count; ++i) {
                  cond = ...; // ignored
                }

            input (trip_count, cond)
                int trip_count = ...;
                bool cond = ...;
                for (int i=0; i < trip_count && cond; ++i) {
                  cond = ...;
                }


        *Sample usage - cond as well as trip count*

            graph predict-net {
              %a = Constant[value = <Scalar Tensor [3]>]()
              %b = Constant[value = <Scalar Tensor [6]>]()
              %keepgoing = Constant[value = <Scalar Tensor [1]>]()
              %max_trip_count = Constant[value = <Scalar Tensor [10]>]()
              %keepgoing_out, %b_out, %user_defined_vals = Loop[body = <graph body-net>](%max_trip_count, %keepgoing, %b)
              return
            }

            graph body-net (
              %i[INT32, scalar]
              %keepgoing[BOOL, scalar]
              %b[INT32, scalar]
            ) {
              %my_local = Add(%a, %b)
              %b_out = Sub(%a, %b)
              %keepgoing_out = Greater(%my_local, %b_out)
              %user_defined_vals = Add(%b, %b)
              return %keepgoing_out, %b_out, %user_defined_vals
            }

        *Sample equivalent C code*

            {
              /* User-defined code (enclosing scope) */
              int a = 3, b = 6;
              bool keepgoing = true; // Analogous to input cond
              /* End user-defined code */

              /* Implicitly-defined code */
              const int max_trip_count = 10; // Analogous to input M
              int user_defined_vals[]; // Imagine this is resizable
              /* End implicitly-defined code */
              for (int i=0; i < max_trip_count && keepgoing; ++i) {
                /* User-defined code (loop body) */
                int my_local = a + b; // Reading values in the enclosing scope is fine
                b = a - b; // writes fine if we specify b as a loop-carried dependency
                keepgoing = my_local > b; // keepgoing is a loop-carried dependency
                user_defined_vals[i] = b + b;
                /* End user-defined code */
              }
              // my_local = 123; // Can't do this. my_local was defined in the body

              // These below values are live-out from the loop and therefore accessible
              b_out; user_defined_vals; keepgoing_out;
            }

        There are several things of note in this code snippet:

        1) Values from the enclosing scope (i.e. variable a here) are in scope and can
           be referenced in the inputs of the loop.
        2) Any variables which you wish to make available in the enclosing scope (i.e.
           the variables b and keepgoing) must be declared as either loop-carried
           dependencies (both at the op inputs and output and at the body net input and
           output) or scan_outputs.
        3) Values created in the body cannot be accessed in the enclosing scope.

        Note that the semantics of this op support "diagonal" or "wavefront" execution.
        (See Step 3 here for an example:
        https://devblogs.nvidia.com/optimizing-recurrent-neural-networks-cudnn-5/).
        Frontends should emit multi-layer RNNs as a series of While operators (with
        time being the inner looping dimension), with each successive layer consuming
        the scan_outputs from the previous layer, possibly going through several
        point-wise operators (e.g. dropout, residual connections, linear layer).


        Args:
            M: (optional) A maximum trip-count for the loop specified at runtime.
                Optional. Pass empty string to skip.

            cond: (optional) A boolean termination condition. Optional. Pass empty
                string to skip.

            v_initial: (variadic, heterogeneous) The initial values of any loop-carried
                dependencies (values that change across loop iterations)

            body: The graph run each iteration. It has 2+N inputs: (iteration_num,
                condition, loop carried dependencies...). It has 1+N+K outputs:
                (condition, loop carried dependencies..., scan_outputs...). Each
                scan_output is created by concatenating the value of the specified
                output value at the end of each iteration of the loop. It is an error if
                the dimensions or data type of these scan_outputs change across loop
                iterations.
        """

        schema = get_schema("Loop", 1, "")
        op = Op(self, "Loop", schema)
        return op(*self._prepare_inputs(schema, M, cond, *v_initial), body=body)

    T_LpNormalization = TypeVar("T_LpNormalization", DOUBLE, FLOAT, FLOAT16)

    def LpNormalization(
        self, input: T_LpNormalization, *, axis: int = -1, p: int = 2
    ) -> T_LpNormalization:
        r"""[🌐 LpNormalization(1)](https://onnx.ai/onnx/operators/onnx__LpNormalization.html#lpnormalization-1 "Online Documentation")


        Given a matrix, apply Lp-normalization along the provided axis.


        Args:
            input: (differentiable) Input matrix

            axis: The axis on which to apply normalization, -1 mean last axis.

            p: The order of the normalization, only 1 or 2 are supported.
        """

        schema = get_schema("LpNormalization", 1, "")
        op = Op(self, "LpNormalization", schema)
        return op(*self._prepare_inputs(schema, input), axis=axis, p=p)

    T_LpPool = TypeVar("T_LpPool", DOUBLE, FLOAT, FLOAT16)

    def LpPool(
        self,
        X: T_LpPool,
        *,
        auto_pad: str = "NOTSET",
        kernel_shape: Optional[Sequence[int]] = None,
        p: float = 2.0,
        pads: Optional[Sequence[int]] = None,
        strides: Optional[Sequence[int]] = None,
    ) -> T_LpPool:
        r"""[🌐 LpPool(1)](https://onnx.ai/onnx/operators/onnx__LpPool.html#lppool-1 "Online Documentation")


         LpPool consumes an input tensor X and applies Lp pooling across the
         the tensor according to kernel sizes, stride sizes, and pad lengths.
         Lp pooling consisting of computing the Lp norm on all values of a subset
         of the input tensor according to the kernel size and downsampling the
         data into the output tensor Y for further processing.

        Args:
            X: Input data tensor from the previous operator; dimensions for image case
                are (N x C x H x W), where N is the batch size, C is the number of
                channels, and H and W are the height and the width of the data. For non
                image case, the dimension are in the form of (N x C x D1 x D2 ... Dn),
                where N is the batch size.

            auto_pad: auto_pad must be either NOTSET, SAME_UPPER, SAME_LOWER or VALID.
                Where default value is NOTSET, which means explicit padding is used.
                SAME_UPPER or SAME_LOWER mean pad the input so that the output size
                match the input.In case of odd number add the extra padding at the end
                for SAME_UPPER and at the beginning for SAME_LOWER. VALID mean no
                padding. DEPRECATION NOTE: auto_pad is only intended to support legacy
                uses, and for framework authors, one is explicitly encouraged to use
                explicit padding specified in the pads attribute.

            kernel_shape: The size of the kernel along each axis.

            p: p value of the Lp norm used to pool over the input data, default is 2.0.

            pads: Padding for the beginning and ending along each axis, it can take any
                value greater than or equal to 0. The value represent the number of
                pixels added to the beginning and end part of the corresponding axis.
                `pads` format should be as follow [x1_begin, x2_begin...x1_end,
                x2_end,...], where xi_begin the number of pixels added at the beginning
                of axis `i` and xi_end, the number of pixels added at the end of axis
                `i`. This attribute cannot be used simultaneously with auto_pad
                attribute.

            strides: Stride along each axis.
        """

        schema = get_schema("LpPool", 1, "")
        op = Op(self, "LpPool", schema)
        return op(
            *self._prepare_inputs(schema, X),
            auto_pad=auto_pad,
            kernel_shape=kernel_shape,
            p=p,
            pads=pads,
            strides=strides,
        )

    T_MatMul = TypeVar("T_MatMul", DOUBLE, FLOAT, FLOAT16)

    def MatMul(self, A: T_MatMul, B: T_MatMul) -> T_MatMul:
        r"""[🌐 MatMul(1)](https://onnx.ai/onnx/operators/onnx__MatMul.html#matmul-1 "Online Documentation")


        Matrix product that behaves like [numpy.matmul](https://numpy.org/doc/stable/reference/generated/numpy.matmul.html).


        Args:
            A: N-dimensional matrix A

            B: N-dimensional matrix B
        """

        schema = get_schema("MatMul", 1, "")
        op = Op(self, "MatMul", schema)
        return op(*self._prepare_inputs(schema, A, B))

    T_Max = TypeVar("T_Max", DOUBLE, FLOAT, FLOAT16)

    def Max(self, *data_0: T_Max, consumed_inputs: Optional[Sequence[int]] = None) -> T_Max:
        r"""[🌐 Max(1)](https://onnx.ai/onnx/operators/onnx__Max.html#max-1 "Online Documentation")


        Element-wise max of each of the input tensors. All inputs and outputs must
        have the same shape and data type.


        Args:
            data_0: (variadic) List of tensors for Max.

            consumed_inputs: legacy optimization attribute.
        """

        schema = get_schema("Max", 1, "")
        op = Op(self, "Max", schema)
        return op(*self._prepare_inputs(schema, *data_0), consumed_inputs=consumed_inputs)

    T_MaxPool = TypeVar("T_MaxPool", DOUBLE, FLOAT, FLOAT16)

    def MaxPool(
        self,
        X: T_MaxPool,
        *,
        auto_pad: str = "NOTSET",
        kernel_shape: Sequence[int],
        pads: Optional[Sequence[int]] = None,
        strides: Optional[Sequence[int]] = None,
    ) -> T_MaxPool:
        r"""[🌐 MaxPool(1)](https://onnx.ai/onnx/operators/onnx__MaxPool.html#maxpool-1 "Online Documentation")


         MaxPool consumes an input tensor X and applies max pooling across
         the tensor according to kernel sizes, stride sizes, and pad lengths.
         max pooling consisting of computing the max on all values of a
         subset of the input tensor according to the kernel size and downsampling the
         data into the output tensor Y for further processing. The output spatial shape will be following:
         ```
         output_spatial_shape[i] = floor((input_spatial_shape[i] + pad_shape[i] - kernel_spatial_shape[i]) / strides_spatial_shape[i] + 1)

         * pad_shape[i] is sum of pads along axis i
         ```

         `auto_pad` is a DEPRECATED attribute. If you are using them currently, the output spatial shape will be following:
         ```
         VALID: output_spatial_shape[i] = ceil((input_spatial_shape[i] - kernel_spatial_shape[i] + 1) / strides_spatial_shape[i])
         SAME_UPPER or SAME_LOWER: output_spatial_shape[i] = ceil(input_spatial_shape[i] / strides_spatial_shape[i])
         ```
         And pad shape will be following if `SAME_UPPER` or `SAME_LOWER`:
         ```
         pad_shape[i] = (output_spatial_shape[i] - 1) * strides_spatial_shape[i] + kernel_spatial_shape[i] - input_spatial_shape[i]
         ```
         The output of each pooling window is maximum number of elements exclude pad.


        Args:
            X: Input data tensor from the previous operator; dimensions for image case
                are (N x C x H x W), where N is the batch size, C is the number of
                channels, and H and W are the height and the width of the data. For non
                image case, the dimensions are in the form of (N x C x D1 x D2 ... Dn),
                where N is the batch size. Optionally, if dimension denotation is in
                effect, the operation expects the input data tensor to arrive with the
                dimension denotation of [DATA_BATCH, DATA_CHANNEL, DATA_FEATURE,
                DATA_FEATURE ...].

            auto_pad: auto_pad must be either NOTSET, SAME_UPPER, SAME_LOWER or VALID.
                Where default value is NOTSET, which means explicit padding is used.
                SAME_UPPER or SAME_LOWER mean pad the input so that the output spatial
                size match the input.In case of odd number add the extra padding at the
                end for SAME_UPPER and at the beginning for SAME_LOWER. VALID mean no
                padding.

            kernel_shape: The size of the kernel along each axis.

            pads: Padding for the beginning and ending along each spatial axis, it can
                take any value greater than or equal to 0. The value represent the
                number of pixels added to the beginning and end part of the
                corresponding axis. `pads` format should be as follow [x1_begin,
                x2_begin...x1_end, x2_end,...], where xi_begin the number of pixels
                added at the beginning of axis `i` and xi_end, the number of pixels
                added at the end of axis `i`. This attribute cannot be used
                simultaneously with auto_pad attribute. If not present, the padding
                defaults to 0 along start and end of each spatial axis.

            strides: Stride along each spatial axis.
        """

        schema = get_schema("MaxPool", 1, "")
        op = Op(self, "MaxPool", schema)
        return op(
            *self._prepare_inputs(schema, X),
            auto_pad=auto_pad,
            kernel_shape=kernel_shape,
            pads=pads,
            strides=strides,
        )

    T_MaxRoiPool = TypeVar("T_MaxRoiPool", DOUBLE, FLOAT, FLOAT16)

    def MaxRoiPool(
        self,
        X: T_MaxRoiPool,
        rois: T_MaxRoiPool,
        *,
        pooled_shape: Sequence[int],
        spatial_scale: float = 1.0,
    ) -> T_MaxRoiPool:
        r"""[🌐 MaxRoiPool(1)](https://onnx.ai/onnx/operators/onnx__MaxRoiPool.html#maxroipool-1 "Online Documentation")


         ROI max pool consumes an input tensor X and region of interests (RoIs) to
         apply max pooling across each RoI, to produce output 4-D tensor of shape
         (num_rois, channels, pooled_shape[0], pooled_shape[1]).

        Args:
            X: (differentiable) Input data tensor from the previous operator; dimensions
                for image case are (N x C x H x W), where N is the batch size, C is the
                number of channels, and H and W are the height and the width of the
                data.

            rois: (non-differentiable) RoIs (Regions of Interest) to pool over. Should
                be a 2-D tensor of shape (num_rois, 5) given as [[batch_id, x1, y1, x2,
                y2], ...].

            pooled_shape: ROI pool output shape (height, width).

            spatial_scale: Multiplicative spatial scale factor to translate ROI
                coordinates from their input scale to the scale used when pooling.
        """

        schema = get_schema("MaxRoiPool", 1, "")
        op = Op(self, "MaxRoiPool", schema)
        return op(
            *self._prepare_inputs(schema, X, rois),
            pooled_shape=pooled_shape,
            spatial_scale=spatial_scale,
        )

    T_Mean = TypeVar("T_Mean", DOUBLE, FLOAT, FLOAT16)

    def Mean(self, *data_0: T_Mean, consumed_inputs: Optional[Sequence[int]] = None) -> T_Mean:
        r"""[🌐 Mean(1)](https://onnx.ai/onnx/operators/onnx__Mean.html#mean-1 "Online Documentation")


        Element-wise mean of each of the input tensors. All inputs and outputs must
        have the same shape and data type.


        Args:
            data_0: (variadic) List of tensors for Mean.

            consumed_inputs: legacy optimization attribute.
        """

        schema = get_schema("Mean", 1, "")
        op = Op(self, "Mean", schema)
        return op(*self._prepare_inputs(schema, *data_0), consumed_inputs=consumed_inputs)

    T_Min = TypeVar("T_Min", DOUBLE, FLOAT, FLOAT16)

    def Min(self, *data_0: T_Min, consumed_inputs: Optional[Sequence[int]] = None) -> T_Min:
        r"""[🌐 Min(1)](https://onnx.ai/onnx/operators/onnx__Min.html#min-1 "Online Documentation")


        Element-wise min of each of the input tensors. All inputs and outputs must
        have the same shape and data type.


        Args:
            data_0: (variadic) List of tensors for Min

            consumed_inputs: legacy optimization attribute.
        """

        schema = get_schema("Min", 1, "")
        op = Op(self, "Min", schema)
        return op(*self._prepare_inputs(schema, *data_0), consumed_inputs=consumed_inputs)

    T_Mul = TypeVar("T_Mul", DOUBLE, FLOAT, FLOAT16)

    def Mul(
        self,
        A: T_Mul,
        B: T_Mul,
        *,
        axis: Optional[int] = None,
        broadcast: int = 0,
        consumed_inputs: Optional[Sequence[int]] = None,
    ) -> T_Mul:
        r"""[🌐 Mul(1)](https://onnx.ai/onnx/operators/onnx__Mul.html#mul-1 "Online Documentation")


        Performs element-wise binary multiplication (with limited broadcast support).

        If necessary the right-hand-side argument will be broadcasted to match the
        shape of left-hand-side argument. When broadcasting is specified, the second
        tensor can either be of element size 1 (including a scalar tensor and any
        tensor with rank equal to or smaller than the first tensor), or having its
        shape as a contiguous subset of the first tensor's shape. The starting of the
        mutually equal shape is specified by the argument "axis", and if it is not set,
        suffix matching is assumed. 1-dim expansion doesn't work yet.

        For example, the following tensor shapes are supported (with broadcast=1):

          shape(A) = (2, 3, 4, 5), shape(B) = (,), i.e. B is a scalar tensor
          shape(A) = (2, 3, 4, 5), shape(B) = (1, 1), i.e. B is an 1-element tensor
          shape(A) = (2, 3, 4, 5), shape(B) = (5,)
          shape(A) = (2, 3, 4, 5), shape(B) = (4, 5)
          shape(A) = (2, 3, 4, 5), shape(B) = (3, 4), with axis=1
          shape(A) = (2, 3, 4, 5), shape(B) = (2), with axis=0

        Attribute `broadcast=1` needs to be passed to enable broadcasting.


        Args:
            A: First operand, should share the type with the second operand.

            B: Second operand. With broadcasting can be of smaller size than A. If
                broadcasting is disabled it should be of the same size.

            axis: If set, defines the broadcast dimensions. See doc for details.

            broadcast: Pass 1 to enable broadcasting

            consumed_inputs: legacy optimization attribute.
        """

        schema = get_schema("Mul", 1, "")
        op = Op(self, "Mul", schema)
        return op(
            *self._prepare_inputs(schema, A, B),
            axis=axis,
            broadcast=broadcast,
            consumed_inputs=consumed_inputs,
        )

    T_Neg = TypeVar("T_Neg", DOUBLE, FLOAT, FLOAT16)

    def Neg(self, X: T_Neg, *, consumed_inputs: Optional[Sequence[int]] = None) -> T_Neg:
        r"""[🌐 Neg(1)](https://onnx.ai/onnx/operators/onnx__Neg.html#neg-1 "Online Documentation")


        Neg takes one input data (Tensor<T>) and produces one output data
        (Tensor<T>) where each element flipped sign, y = -x, is applied to
        the tensor elementwise.


        Args:
            X: Input tensor

            consumed_inputs: legacy optimization attribute.
        """

        schema = get_schema("Neg", 1, "")
        op = Op(self, "Neg", schema)
        return op(*self._prepare_inputs(schema, X), consumed_inputs=consumed_inputs)

    T_Not: TypeAlias = BOOL

    def Not(self, X: T_Not) -> T_Not:
        r"""[🌐 Not(1)](https://onnx.ai/onnx/operators/onnx__Not.html#not-1 "Online Documentation")


        Returns the negation of the input tensor element-wise.


        Args:
            X: (non-differentiable) Input tensor
        """

        schema = get_schema("Not", 1, "")
        op = Op(self, "Not", schema)
        return op(*self._prepare_inputs(schema, X))

    T_Or: TypeAlias = BOOL

    T1_Or: TypeAlias = BOOL

    def Or(self, A: T_Or, B: T_Or, *, axis: Optional[int] = None, broadcast: int = 0) -> T1_Or:
        r"""[🌐 Or(1)](https://onnx.ai/onnx/operators/onnx__Or.html#or-1 "Online Documentation")


        Returns the tensor resulted from performing the `or` logical operation
        elementwise on the input tensors `A` and `B`.

        If broadcasting is enabled, the right-hand-side argument will be broadcasted
        to match the shape of left-hand-side argument. See the doc of `Add` for a
        detailed description of the broadcasting rules.


        Args:
            A: Left input tensor for the logical operator.

            B: Right input tensor for the logical operator.

            axis: If set, defines the broadcast dimensions.

            broadcast: Enable broadcasting
        """

        schema = get_schema("Or", 1, "")
        op = Op(self, "Or", schema)
        return op(*self._prepare_inputs(schema, A, B), axis=axis, broadcast=broadcast)

    T_PRelu = TypeVar("T_PRelu", DOUBLE, FLOAT, FLOAT16)

    def PRelu(
        self, X: T_PRelu, slope: T_PRelu, *, consumed_inputs: Optional[Sequence[int]] = None
    ) -> T_PRelu:
        r"""[🌐 PRelu(1)](https://onnx.ai/onnx/operators/onnx__PRelu.html#prelu-1 "Online Documentation")



        PRelu takes input data (Tensor<T>) and slope tensor as input, and produces one
        output data (Tensor<T>) where the function `f(x) = slope * x for x < 0`,
        `f(x) = x for x >= 0`., is applied to the data tensor elementwise.



        Args:
            X: Input tensor

            slope: Slope tensor. If `Slope` is of size 1, the value is sharedacross
                different channels

            consumed_inputs: legacy optimization attribute.
        """

        schema = get_schema("PRelu", 1, "")
        op = Op(self, "PRelu", schema)
        return op(*self._prepare_inputs(schema, X, slope), consumed_inputs=consumed_inputs)

    T_Pad = TypeVar("T_Pad", DOUBLE, FLOAT, FLOAT16)

    def Pad(
        self,
        data: T_Pad,
        *,
        mode: str = "constant",
        paddings: Sequence[int],
        value: float = 0.0,
    ) -> T_Pad:
        r"""[🌐 Pad(1)](https://onnx.ai/onnx/operators/onnx__Pad.html#pad-1 "Online Documentation")


        Given `data` tensor, paddings, mode, and value.
        Example:
          Insert 0 paddings to the beginning of the second dimension.
          data = [
              [1.0, 1.2],
              [2.3, 3.4],
              [4.5, 5.7],
          ]
          paddings = [0, 0, 2, 0]
          output = [
              [
                  [0.0, 0.0, 1.0, 1.2],
                  [0.0, 0.0, 2.3, 3.4],
                  [0.0, 0.0, 4.5, 5.7],
              ],
          ]


        Args:
            data: Input tensor.

            mode: Three modes: constant(default), reflect, edge

            paddings: List of integers indicate the padding element count at the
                beginning and end of each axis, for 2D it is the number of pixel.
                `paddings` rank should be double of the input's rank. `paddings` format
                should be as follow [x1_begin, x2_begin...x1_end, x2_end,...], where
                xi_begin the number of pixels added at the beginning of axis `i` and
                xi_end, the number of pixels added at the end of axis `i`.

            value: One float, indicates the value to be filled, default is 0
        """

        schema = get_schema("Pad", 1, "")
        op = Op(self, "Pad", schema)
        return op(
            *self._prepare_inputs(schema, data), mode=mode, paddings=paddings, value=value
        )

    T_Pow = TypeVar("T_Pow", DOUBLE, FLOAT, FLOAT16)

    def Pow(
        self, X: T_Pow, Y: T_Pow, *, axis: Optional[int] = None, broadcast: int = 0
    ) -> T_Pow:
        r"""[🌐 Pow(1)](https://onnx.ai/onnx/operators/onnx__Pow.html#pow-1 "Online Documentation")


        Pow takes input data (Tensor<T>) and exponent Tensor, and
        produces one output data (Tensor<T>) where the function `f(x) = x^exponent`,
        is applied to the data tensor elementwise.

        If necessary the right-hand-side argument will be broadcasted to match the
        shape of left-hand-side argument. When broadcasting is specified, the second
        tensor can either be of element size 1 (including a scalar tensor and any
        tensor with rank equal to or smaller than the first tensor), or having its
        shape as a contiguous subset of the first tensor's shape. The starting of the
        mutually equal shape is specified by the argument "axis", and if it is not set,
        suffix matching is assumed. 1-dim expansion doesn't work yet.

        For example, the following tensor shapes are supported (with broadcast=1):

          shape(A) = (2, 3, 4, 5), shape(B) = (,), i.e. B is a scalar tensor
          shape(A) = (2, 3, 4, 5), shape(B) = (1, 1), i.e. B is an 1-element tensor
          shape(A) = (2, 3, 4, 5), shape(B) = (5,)
          shape(A) = (2, 3, 4, 5), shape(B) = (4, 5)
          shape(A) = (2, 3, 4, 5), shape(B) = (3, 4), with axis=1
          shape(A) = (2, 3, 4, 5), shape(B) = (2), with axis=0

        Attribute `broadcast=1` needs to be passed to enable broadcasting.


        Args:
            X: Input tensor of any shape, base of the exponent.

            Y: Input tensor of any shape broadcastable to X shape, the exponent
                component.

            axis: If set, defines the broadcast dimensions. See doc for details.

            broadcast: Pass 1 to enable broadcasting
        """

        schema = get_schema("Pow", 1, "")
        op = Op(self, "Pow", schema)
        return op(*self._prepare_inputs(schema, X, Y), axis=axis, broadcast=broadcast)

    T_RNN = TypeVar("T_RNN", DOUBLE, FLOAT, FLOAT16)

    T1_RNN: TypeAlias = INT32

    def RNN(
        self,
        X: T_RNN,
        W: T_RNN,
        R: T_RNN,
        B: Optional[T_RNN] = None,
        sequence_lens: Optional[T1_RNN] = None,
        initial_h: Optional[T_RNN] = None,
        *,
        activation_alpha: Optional[Sequence[float]] = None,
        activation_beta: Optional[Sequence[float]] = None,
        activations: Sequence[str] = ("Tanh", "Tanh"),
        clip: Optional[float] = None,
        direction: str = "forward",
        hidden_size: Optional[int] = None,
        output_sequence: int = 0,
    ) -> Tuple[T_RNN, T_RNN]:
        r"""[🌐 RNN(1)](https://onnx.ai/onnx/operators/onnx__RNN.html#rnn-1 "Online Documentation")


        Computes an one-layer simple RNN. This operator is usually supported
        via some custom implementation such as CuDNN.

        Notations:

        `X` - input tensor

        `i` - input gate

        `t` - time step (t-1 means previous time step)

        `Wi` - W parameter weight matrix for input gate

        `Ri` - R recurrence weight matrix for input gate

        `Wbi` - W parameter bias vector for input gate

        `Rbi` - R parameter bias vector for input gate

        `WBi` - W parameter weight matrix for backward input gate

        `RBi` - R recurrence weight matrix for backward input gate

        `WBbi` - WR bias vectors for backward input gate

        `RBbi` - RR bias vectors for backward input gate

        `H` - Hidden state

        `num_directions` - 2 if direction == bidirectional else 1

        Activation functions:

          Relu(x)                - max(0, x)

          Tanh(x)                - (1 - e^{-2x})/(1 + e^{-2x})

          Sigmoid(x)             - 1/(1 + e^{-x})

          (NOTE: Below are optional)

          Affine(x)              - alpha*x + beta

          LeakyRelu(x)           - x if x >= 0 else alpha * x

          ThresholdedRelu(x)     - x if x >= alpha else 0

          ScaledTanh(x)          - alpha*Tanh(beta*x)

          HardSigmoid(x)         - min(max(alpha*x + beta, 0), 1)

          Elu(x)                 - x if x >= 0 else alpha*(e^x - 1)

          Softsign(x)            - x/(1 + |x|)

          Softplus(x)            - log(1 + e^x)

        Equations (Default: f=Tanh):

          - Ht = f(Xt*(Wi^T) + Ht-1*Ri + Wbi + Rbi)


        Args:
            X: The input sequences packed (and potentially padded) into one 3-D tensor
                with the shape of `[seq_length, batch_size, input_size]`.

            W: The weight tensor for input gate. Concatenation of `Wi` and `WBi` (if
                bidirectional). The tensor has shape `[num_directions, hidden_size,
                input_size]`.

            R: The recurrence weight tensor. Concatenation of `Ri` and `RBi` (if
                bidirectional). The tensor has shape `[num_directions, hidden_size,
                hidden_size]`.

            B: (optional) The bias tensor for input gate. Concatenation of `[Wbi, Rbi]`
                and `[WBbi, RBbi]` (if bidirectional). The tensor has shape
                `[num_directions, 2*hidden_size]`. Optional: If not specified - assumed
                to be 0.

            sequence_lens: (optional) Optional tensor specifying lengths of the
                sequences in a batch. If not specified - assumed all sequences in the
                batch to have length `seq_length`. It has shape `[batch_size]`.

            initial_h: (optional) Optional initial value of the hidden. If not specified
                - assumed to be 0. It has shape `[num_directions, batch_size,
                hidden_size]`.

            activation_alpha: Optional scaling values used by some activation functions.
                The values are consumed in the order of activation functions, for
                example (f, g, h) in LSTM. Default values are the same as of
                corresponding ONNX operators.For example with LeakyRelu, the default
                alpha is 0.01.

            activation_beta: Optional scaling values used by some activation functions.
                The values are consumed in the order of activation functions, for
                example (f, g, h) in LSTM. Default values are the same as of
                corresponding ONNX operators.

            activations: One (or two if bidirectional) activation function for input
                gate. The activation function must be one of the activation functions
                specified above. Optional: Default `Tanh` if not specified.

            clip: Cell clip threshold. Clipping bounds the elements of a tensor in the
                range of [-threshold, +threshold] and is applied to the input of
                activations. No clip if not specified.

            direction: Specify if the RNN is forward, reverse, or bidirectional. Must be
                one of forward (default), reverse, or bidirectional.

            hidden_size: Number of neurons in the hidden layer

            output_sequence: The sequence output for the hidden is optional if 0.
                Default 0.
        """

        schema = get_schema("RNN", 1, "")
        op = Op(self, "RNN", schema)
        return op(
            *self._prepare_inputs(schema, X, W, R, B, sequence_lens, initial_h),
            activation_alpha=activation_alpha,
            activation_beta=activation_beta,
            activations=activations,
            clip=clip,
            direction=direction,
            hidden_size=hidden_size,
            output_sequence=output_sequence,
        )

    T_RandomNormal: TypeAlias = Union[DOUBLE, FLOAT, FLOAT16]

    def RandomNormal(
        self,
        *,
        dtype: int = 1,
        mean: float = 0.0,
        scale: float = 1.0,
        seed: Optional[float] = None,
        shape: Sequence[int],
    ) -> T_RandomNormal:
        r"""[🌐 RandomNormal(1)](https://onnx.ai/onnx/operators/onnx__RandomNormal.html#randomnormal-1 "Online Documentation")


        Generate a tensor with random values drawn from a normal distribution. The shape
        of the tensor is specified by the `shape` argument and the parameter of the normal distribution
        specified by `mean` and `scale`.

        The data type is specified by the 'dtype' argument. The 'dtype' argument must
        be one of the data types specified in the 'DataType' enum field in the
        TensorProto message.


        Args:
            dtype: The data type for the elements of the output tensor. Default is
                TensorProto::FLOAT.

            mean: The mean of the normal distribution.

            scale: The standard deviation of the normal distribution.

            seed: (Optional) Seed to the random generator, if not specified we will auto
                generate one.

            shape: The shape of the output tensor.
        """

        schema = get_schema("RandomNormal", 1, "")
        op = Op(self, "RandomNormal", schema)
        return op(dtype=dtype, mean=mean, scale=scale, seed=seed, shape=shape)

    T1_RandomNormalLike = TypeVar(
        "T1_RandomNormalLike",
        BOOL,
        COMPLEX128,
        COMPLEX64,
        DOUBLE,
        FLOAT,
        FLOAT16,
        INT16,
        INT32,
        INT64,
        INT8,
        STRING,
        UINT16,
        UINT32,
        UINT64,
        UINT8,
    )

    T2_RandomNormalLike: TypeAlias = Union[DOUBLE, FLOAT, FLOAT16]

    def RandomNormalLike(
        self,
        input: T1_RandomNormalLike,
        *,
        dtype: Optional[int] = None,
        mean: float = 0.0,
        scale: float = 1.0,
        seed: Optional[float] = None,
    ) -> T2_RandomNormalLike:
        r"""[🌐 RandomNormalLike(1)](https://onnx.ai/onnx/operators/onnx__RandomNormalLike.html#randomnormallike-1 "Online Documentation")


        Generate a tensor with random values drawn from a normal distribution.
        The shape of the output tensor is copied from the shape of the input tensor,
        and the parameters of the normal distribution are specified by `mean` and `scale`.

        The data type is specified by the 'dtype' argument, or copied from the input tensor if not provided.
        The 'dtype' argument must be one of the data types specified in the 'DataType' enum field in the
        TensorProto message, and be valid as an output type.


        Args:
            input: Input tensor to copy shape and optionally type information from.

            dtype: (Optional) The data type for the elements of the output tensor, if
                not specified, we will use the data type of the input tensor.

            mean: The mean of the normal distribution.

            scale: The standard deviation of the normal distribution.

            seed: (Optional) Seed to the random generator, if not specified we will auto
                generate one.
        """

        schema = get_schema("RandomNormalLike", 1, "")
        op = Op(self, "RandomNormalLike", schema)
        return op(
            *self._prepare_inputs(schema, input),
            dtype=dtype,
            mean=mean,
            scale=scale,
            seed=seed,
        )

    T_RandomUniform: TypeAlias = Union[DOUBLE, FLOAT, FLOAT16]

    def RandomUniform(
        self,
        *,
        dtype: int = 1,
        high: float = 1.0,
        low: float = 0.0,
        seed: Optional[float] = None,
        shape: Sequence[int],
    ) -> T_RandomUniform:
        r"""[🌐 RandomUniform(1)](https://onnx.ai/onnx/operators/onnx__RandomUniform.html#randomuniform-1 "Online Documentation")


        Generate a tensor with random values drawn from a uniform distribution. The shape
        of the tensor is specified by the `shape` argument and the range by `low` and `high`.

        The data type is specified by the 'dtype' argument. The 'dtype' argument must
        be one of the data types specified in the 'DataType' enum field in the
        TensorProto message.


        Args:
            dtype: The data type for the elements of the output tensor. If not
                specified, default is TensorProto::FLOAT.

            high: Upper boundary of the output values.

            low: Lower boundary of the output values.

            seed: (Optional) Seed to the random generator, if not specified we will auto
                generate one.

            shape: The shape of the output tensor.
        """

        schema = get_schema("RandomUniform", 1, "")
        op = Op(self, "RandomUniform", schema)
        return op(dtype=dtype, high=high, low=low, seed=seed, shape=shape)

    T1_RandomUniformLike = TypeVar(
        "T1_RandomUniformLike",
        BOOL,
        COMPLEX128,
        COMPLEX64,
        DOUBLE,
        FLOAT,
        FLOAT16,
        INT16,
        INT32,
        INT64,
        INT8,
        STRING,
        UINT16,
        UINT32,
        UINT64,
        UINT8,
    )

    T2_RandomUniformLike: TypeAlias = Union[DOUBLE, FLOAT, FLOAT16]

    def RandomUniformLike(
        self,
        input: T1_RandomUniformLike,
        *,
        dtype: Optional[int] = None,
        high: float = 1.0,
        low: float = 0.0,
        seed: Optional[float] = None,
    ) -> T2_RandomUniformLike:
        r"""[🌐 RandomUniformLike(1)](https://onnx.ai/onnx/operators/onnx__RandomUniformLike.html#randomuniformlike-1 "Online Documentation")


        Generate a tensor with random values drawn from a uniform distribution.
        The shape of the output tensor is copied from the shape of the input tensor,
        and the parameters of the uniform distribution are specified by `low` and `high`.

        The data type is specified by the 'dtype' argument, or copied from the input tensor if not provided.
        The 'dtype' argument must be one of the data types specified in the 'DataType' enum field in the
        TensorProto message and be valid as an output type.


        Args:
            input: Input tensor to copy shape and optionally type information from.

            dtype: (Optional) The data type for the elements of the output tensor, if
                not specified, we will use the data type of the input tensor.

            high: Upper boundary of the output values.

            low: Lower boundary of the output values.

            seed: (Optional) Seed to the random generator, if not specified we will auto
                generate one.
        """

        schema = get_schema("RandomUniformLike", 1, "")
        op = Op(self, "RandomUniformLike", schema)
        return op(
            *self._prepare_inputs(schema, input), dtype=dtype, high=high, low=low, seed=seed
        )

    T_Reciprocal = TypeVar("T_Reciprocal", DOUBLE, FLOAT, FLOAT16)

    def Reciprocal(
        self, X: T_Reciprocal, *, consumed_inputs: Optional[Sequence[int]] = None
    ) -> T_Reciprocal:
        r"""[🌐 Reciprocal(1)](https://onnx.ai/onnx/operators/onnx__Reciprocal.html#reciprocal-1 "Online Documentation")


        Reciprocal takes one input data (Tensor<T>) and produces one output data
        (Tensor<T>) where the reciprocal is, y = 1/x, is applied to
        the tensor elementwise.


        Args:
            X: Input tensor

            consumed_inputs: legacy optimization attribute.
        """

        schema = get_schema("Reciprocal", 1, "")
        op = Op(self, "Reciprocal", schema)
        return op(*self._prepare_inputs(schema, X), consumed_inputs=consumed_inputs)

    T_ReduceL1 = TypeVar("T_ReduceL1", DOUBLE, FLOAT, FLOAT16, INT32, INT64, UINT32, UINT64)

    def ReduceL1(
        self, data: T_ReduceL1, *, axes: Optional[Sequence[int]] = None, keepdims: int = 1
    ) -> T_ReduceL1:
        r"""[🌐 ReduceL1(1)](https://onnx.ai/onnx/operators/onnx__ReduceL1.html#reducel1-1 "Online Documentation")


        Computes the L1 norm of the input tensor's element along the provided axes. The resulting
        tensor has the same rank as the input if keepdims equals 1. If keepdims equal 0, then
        the resulted tensor have the reduced dimension pruned. Input tensors of rank zero are
        valid. Reduction over an empty set of values yields 0.

        The above behavior is similar to numpy, with the exception that numpy defaults keepdims to
        False instead of True.

        Args:
            data: An input tensor.

            axes: A list of integers, along which to reduce. The default is to reduce
                over all the dimensions of the input tensor.

            keepdims: Keep the reduced dimension or not, default 1 means keep reduced
                dimension.
        """

        schema = get_schema("ReduceL1", 1, "")
        op = Op(self, "ReduceL1", schema)
        return op(*self._prepare_inputs(schema, data), axes=axes, keepdims=keepdims)

    T_ReduceL2 = TypeVar("T_ReduceL2", DOUBLE, FLOAT, FLOAT16, INT32, INT64, UINT32, UINT64)

    def ReduceL2(
        self, data: T_ReduceL2, *, axes: Optional[Sequence[int]] = None, keepdims: int = 1
    ) -> T_ReduceL2:
        r"""[🌐 ReduceL2(1)](https://onnx.ai/onnx/operators/onnx__ReduceL2.html#reducel2-1 "Online Documentation")


        Computes the L2 norm of the input tensor's element along the provided axes. The resulting
        tensor has the same rank as the input if keepdims equals 1. If keepdims equal 0, then
        the resulted tensor have the reduced dimension pruned. Input tensors of rank zero are
        valid. Reduction over an empty set of values yields 0.

        The above behavior is similar to numpy, with the exception that numpy defaults keepdims to
        False instead of True.

        Args:
            data: An input tensor.

            axes: A list of integers, along which to reduce. The default is to reduce
                over all the dimensions of the input tensor.

            keepdims: Keep the reduced dimension or not, default 1 means keep reduced
                dimension.
        """

        schema = get_schema("ReduceL2", 1, "")
        op = Op(self, "ReduceL2", schema)
        return op(*self._prepare_inputs(schema, data), axes=axes, keepdims=keepdims)

    T_ReduceLogSum = TypeVar(
        "T_ReduceLogSum", DOUBLE, FLOAT, FLOAT16, INT32, INT64, UINT32, UINT64
    )

    def ReduceLogSum(
        self, data: T_ReduceLogSum, *, axes: Optional[Sequence[int]] = None, keepdims: int = 1
    ) -> T_ReduceLogSum:
        r"""[🌐 ReduceLogSum(1)](https://onnx.ai/onnx/operators/onnx__ReduceLogSum.html#reducelogsum-1 "Online Documentation")


        Computes the log sum of the input tensor's element along the provided axes. The resulting
        tensor has the same rank as the input if keepdims equals 1. If keepdims equal 0, then
        the resulted tensor have the reduced dimension pruned. Input tensors of rank zero are
        valid. Reduction over an empty set of values yields minus infinity (if supported by the datatype) or undefined otherwise.

        The above behavior is similar to numpy, with the exception that numpy defaults keepdims to
        False instead of True.

        Args:
            data: An input tensor.

            axes: A list of integers, along which to reduce. The default is to reduce
                over all the dimensions of the input tensor.

            keepdims: Keep the reduced dimension or not, default 1 means keep reduced
                dimension.
        """

        schema = get_schema("ReduceLogSum", 1, "")
        op = Op(self, "ReduceLogSum", schema)
        return op(*self._prepare_inputs(schema, data), axes=axes, keepdims=keepdims)

    T_ReduceLogSumExp = TypeVar(
        "T_ReduceLogSumExp", DOUBLE, FLOAT, FLOAT16, INT32, INT64, UINT32, UINT64
    )

    def ReduceLogSumExp(
        self,
        data: T_ReduceLogSumExp,
        *,
        axes: Optional[Sequence[int]] = None,
        keepdims: int = 1,
    ) -> T_ReduceLogSumExp:
        r"""[🌐 ReduceLogSumExp(1)](https://onnx.ai/onnx/operators/onnx__ReduceLogSumExp.html#reducelogsumexp-1 "Online Documentation")


        Computes the log sum exponent of the input tensor's element along the provided axes. The resulting
        tensor has the same rank as the input if keepdims equals 1. If keepdims equal 0, then
        the resulted tensor have the reduced dimension pruned. Input tensors of rank zero are
        valid. Reduction over an empty set of values yields minus infinity (if supported by the datatype) or undefined otherwise.

        The above behavior is similar to numpy, with the exception that numpy defaults keepdims to
        False instead of True.

        Args:
            data: An input tensor.

            axes: A list of integers, along which to reduce. The default is to reduce
                over all the dimensions of the input tensor.

            keepdims: Keep the reduced dimension or not, default 1 means keep reduced
                dimension.
        """

        schema = get_schema("ReduceLogSumExp", 1, "")
        op = Op(self, "ReduceLogSumExp", schema)
        return op(*self._prepare_inputs(schema, data), axes=axes, keepdims=keepdims)

    T_ReduceMax = TypeVar("T_ReduceMax", DOUBLE, FLOAT, FLOAT16, INT32, INT64, UINT32, UINT64)

    def ReduceMax(
        self, data: T_ReduceMax, *, axes: Optional[Sequence[int]] = None, keepdims: int = 1
    ) -> T_ReduceMax:
        r"""[🌐 ReduceMax(1)](https://onnx.ai/onnx/operators/onnx__ReduceMax.html#reducemax-1 "Online Documentation")


        Computes the max of the input tensor's element along the provided axes. The resulting
        tensor has the same rank as the input if keepdims equals 1. If keepdims equal 0, then
        the resulted tensor have the reduced dimension pruned. Input tensors of rank zero are
        valid. Reduction over an empty set of values yields minus infinity (if supported by the datatype) or the minimum value of the data type otherwise.

        The above behavior is similar to numpy, with the exception that numpy defaults keepdims to
        False instead of True.

        Args:
            data: An input tensor.

            axes: A list of integers, along which to reduce. The default is to reduce
                over all the dimensions of the input tensor.

            keepdims: Keep the reduced dimension or not, default 1 means keep reduced
                dimension.
        """

        schema = get_schema("ReduceMax", 1, "")
        op = Op(self, "ReduceMax", schema)
        return op(*self._prepare_inputs(schema, data), axes=axes, keepdims=keepdims)

    T_ReduceMean = TypeVar(
        "T_ReduceMean", DOUBLE, FLOAT, FLOAT16, INT32, INT64, UINT32, UINT64
    )

    def ReduceMean(
        self, data: T_ReduceMean, *, axes: Optional[Sequence[int]] = None, keepdims: int = 1
    ) -> T_ReduceMean:
        r"""[🌐 ReduceMean(1)](https://onnx.ai/onnx/operators/onnx__ReduceMean.html#reducemean-1 "Online Documentation")


        Computes the mean of the input tensor's element along the provided axes. The resulting
        tensor has the same rank as the input if keepdims equals 1. If keepdims equal 0, then
        the resulted tensor have the reduced dimension pruned. Input tensors of rank zero are
        valid. Reduction over an empty set of values yields undefined.

        The above behavior is similar to numpy, with the exception that numpy defaults keepdims to
        False instead of True.

        Args:
            data: An input tensor.

            axes: A list of integers, along which to reduce. The default is to reduce
                over all the dimensions of the input tensor.

            keepdims: Keep the reduced dimension or not, default 1 means keep reduced
                dimension.
        """

        schema = get_schema("ReduceMean", 1, "")
        op = Op(self, "ReduceMean", schema)
        return op(*self._prepare_inputs(schema, data), axes=axes, keepdims=keepdims)

    T_ReduceMin = TypeVar("T_ReduceMin", DOUBLE, FLOAT, FLOAT16, INT32, INT64, UINT32, UINT64)

    def ReduceMin(
        self, data: T_ReduceMin, *, axes: Optional[Sequence[int]] = None, keepdims: int = 1
    ) -> T_ReduceMin:
        r"""[🌐 ReduceMin(1)](https://onnx.ai/onnx/operators/onnx__ReduceMin.html#reducemin-1 "Online Documentation")


        Computes the min of the input tensor's element along the provided axes. The resulting
        tensor has the same rank as the input if keepdims equals 1. If keepdims equal 0, then
        the resulted tensor have the reduced dimension pruned. Input tensors of rank zero are
        valid. Reduction over an empty set of values yields plus infinity (if supported by the datatype) or the maximum value of the data type otherwise.

        The above behavior is similar to numpy, with the exception that numpy defaults keepdims to
        False instead of True.

        Args:
            data: An input tensor.

            axes: A list of integers, along which to reduce. The default is to reduce
                over all the dimensions of the input tensor.

            keepdims: Keep the reduced dimension or not, default 1 means keep reduced
                dimension.
        """

        schema = get_schema("ReduceMin", 1, "")
        op = Op(self, "ReduceMin", schema)
        return op(*self._prepare_inputs(schema, data), axes=axes, keepdims=keepdims)

    T_ReduceProd = TypeVar(
        "T_ReduceProd", DOUBLE, FLOAT, FLOAT16, INT32, INT64, UINT32, UINT64
    )

    def ReduceProd(
        self, data: T_ReduceProd, *, axes: Optional[Sequence[int]] = None, keepdims: int = 1
    ) -> T_ReduceProd:
        r"""[🌐 ReduceProd(1)](https://onnx.ai/onnx/operators/onnx__ReduceProd.html#reduceprod-1 "Online Documentation")


        Computes the product of the input tensor's element along the provided axes. The resulting
        tensor has the same rank as the input if keepdims equals 1. If keepdims equal 0, then
        the resulted tensor have the reduced dimension pruned. Input tensors of rank zero are
        valid. Reduction over an empty set of values yields 1.

        The above behavior is similar to numpy, with the exception that numpy defaults keepdims to
        False instead of True.

        Args:
            data: An input tensor.

            axes: A list of integers, along which to reduce. The default is to reduce
                over all the dimensions of the input tensor.

            keepdims: Keep the reduced dimension or not, default 1 means keep reduced
                dimension.
        """

        schema = get_schema("ReduceProd", 1, "")
        op = Op(self, "ReduceProd", schema)
        return op(*self._prepare_inputs(schema, data), axes=axes, keepdims=keepdims)

    T_ReduceSum = TypeVar("T_ReduceSum", DOUBLE, FLOAT, FLOAT16, INT32, INT64, UINT32, UINT64)

    def ReduceSum(
        self, data: T_ReduceSum, *, axes: Optional[Sequence[int]] = None, keepdims: int = 1
    ) -> T_ReduceSum:
        r"""[🌐 ReduceSum(1)](https://onnx.ai/onnx/operators/onnx__ReduceSum.html#reducesum-1 "Online Documentation")


        Computes the sum of the input tensor's element along the provided axes. The resulting
        tensor has the same rank as the input if keepdims equals 1. If keepdims equal 0, then
        the resulted tensor have the reduced dimension pruned. Input tensors of rank zero are
        valid. Reduction over an empty set of values yields 0.

        The above behavior is similar to numpy, with the exception that numpy defaults keepdims to
        False instead of True.

        Args:
            data: An input tensor.

            axes: A list of integers, along which to reduce. The default is to reduce
                over all the dimensions of the input tensor.

            keepdims: Keep the reduced dimension or not, default 1 means keep reduced
                dimension.
        """

        schema = get_schema("ReduceSum", 1, "")
        op = Op(self, "ReduceSum", schema)
        return op(*self._prepare_inputs(schema, data), axes=axes, keepdims=keepdims)

    T_ReduceSumSquare = TypeVar(
        "T_ReduceSumSquare", DOUBLE, FLOAT, FLOAT16, INT32, INT64, UINT32, UINT64
    )

    def ReduceSumSquare(
        self,
        data: T_ReduceSumSquare,
        *,
        axes: Optional[Sequence[int]] = None,
        keepdims: int = 1,
    ) -> T_ReduceSumSquare:
        r"""[🌐 ReduceSumSquare(1)](https://onnx.ai/onnx/operators/onnx__ReduceSumSquare.html#reducesumsquare-1 "Online Documentation")


        Computes the sum square of the input tensor's element along the provided axes. The resulting
        tensor has the same rank as the input if keepdims equals 1. If keepdims equal 0, then
        the resulted tensor have the reduced dimension pruned. Input tensors of rank zero are
        valid. Reduction over an empty set of values yields 0.

        The above behavior is similar to numpy, with the exception that numpy defaults keepdims to
        False instead of True.

        Args:
            data: An input tensor.

            axes: A list of integers, along which to reduce. The default is to reduce
                over all the dimensions of the input tensor.

            keepdims: Keep the reduced dimension or not, default 1 means keep reduced
                dimension.
        """

        schema = get_schema("ReduceSumSquare", 1, "")
        op = Op(self, "ReduceSumSquare", schema)
        return op(*self._prepare_inputs(schema, data), axes=axes, keepdims=keepdims)

    T_Relu = TypeVar("T_Relu", DOUBLE, FLOAT, FLOAT16)

    def Relu(self, X: T_Relu, *, consumed_inputs: Optional[Sequence[int]] = None) -> T_Relu:
        r"""[🌐 Relu(1)](https://onnx.ai/onnx/operators/onnx__Relu.html#relu-1 "Online Documentation")


        Relu takes one input data (Tensor<T>) and produces one output data
        (Tensor<T>) where the rectified linear function, y = max(0, x), is applied to
        the tensor elementwise.


        Args:
            X: Input tensor

            consumed_inputs: legacy optimization attribute.
        """

        schema = get_schema("Relu", 1, "")
        op = Op(self, "Relu", schema)
        return op(*self._prepare_inputs(schema, X), consumed_inputs=consumed_inputs)

    T_Reshape = TypeVar("T_Reshape", DOUBLE, FLOAT, FLOAT16)

    def Reshape(
        self,
        data: T_Reshape,
        *,
        consumed_inputs: Optional[Sequence[int]] = None,
        shape: Optional[Sequence[int]] = None,
    ) -> T_Reshape:
        r"""[🌐 Reshape(1)](https://onnx.ai/onnx/operators/onnx__Reshape.html#reshape-1 "Online Documentation")


        Reshape the input tensor similar to numpy.reshape.
        It takes a tensor as input and an argument `shape`. It outputs the reshaped tensor.
        At most one dimension of the new shape can be -1. In this case, the value is
        inferred from the size of the tensor and the remaining dimensions. A dimension
        could also be 0, in which case the actual dimension value is unchanged (i.e. taken
        from the input tensor). Shape (second input) could be an empty shape, which means converting to a scalar.
        The input tensor's shape and the output tensor's shape are required to have the same number of elements.

        Args:
            data: An input tensor.

            consumed_inputs: legacy optimization attribute.

            shape: New shape
        """

        schema = get_schema("Reshape", 1, "")
        op = Op(self, "Reshape", schema)
        return op(
            *self._prepare_inputs(schema, data), consumed_inputs=consumed_inputs, shape=shape
        )

    T_Selu = TypeVar("T_Selu", DOUBLE, FLOAT, FLOAT16)

    def Selu(
        self,
        X: T_Selu,
        *,
        alpha: float = 1.673200011253357,
        consumed_inputs: Optional[Sequence[int]] = None,
        gamma: float = 1.0506999492645264,
    ) -> T_Selu:
        r"""[🌐 Selu(1)](https://onnx.ai/onnx/operators/onnx__Selu.html#selu-1 "Online Documentation")


        Selu takes one input data (Tensor<T>) and produces one output data
        (Tensor<T>) where the scaled exponential linear unit function,
        `y = gamma * (alpha * e^x - alpha) for x <= 0`, `y = gamma * x for x > 0`,
        is applied to the tensor elementwise.


        Args:
            X: Input tensor

            alpha: Coefficient of SELU default to 1.6732.

            consumed_inputs: legacy optimization attribute.

            gamma: Coefficient of SELU default to 1.0507.
        """

        schema = get_schema("Selu", 1, "")
        op = Op(self, "Selu", schema)
        return op(
            *self._prepare_inputs(schema, X),
            alpha=alpha,
            consumed_inputs=consumed_inputs,
            gamma=gamma,
        )

    T_Shape = TypeVar(
        "T_Shape",
        BOOL,
        COMPLEX128,
        COMPLEX64,
        DOUBLE,
        FLOAT,
        FLOAT16,
        INT16,
        INT32,
        INT64,
        INT8,
        STRING,
        UINT16,
        UINT32,
        UINT64,
        UINT8,
    )

    T1_Shape: TypeAlias = INT64

    def Shape(self, data: T_Shape) -> T1_Shape:
        r"""[🌐 Shape(1)](https://onnx.ai/onnx/operators/onnx__Shape.html#shape-1 "Online Documentation")


        Takes a tensor as input and outputs an 1D int64 tensor containing the shape of the input tensor.


        Args:
            data: An input tensor.
        """

        schema = get_schema("Shape", 1, "")
        op = Op(self, "Shape", schema)
        return op(*self._prepare_inputs(schema, data))

    T_Sigmoid = TypeVar("T_Sigmoid", DOUBLE, FLOAT, FLOAT16)

    def Sigmoid(
        self, X: T_Sigmoid, *, consumed_inputs: Optional[Sequence[int]] = None
    ) -> T_Sigmoid:
        r"""[🌐 Sigmoid(1)](https://onnx.ai/onnx/operators/onnx__Sigmoid.html#sigmoid-1 "Online Documentation")


        Sigmoid takes one input data (Tensor<T>) and produces one output data
        (Tensor<T>) where the sigmoid function, y = 1 / (1 + exp(-x)), is applied to the
        tensor elementwise.


        Args:
            X: Input tensor

            consumed_inputs: legacy optimization attribute.
        """

        schema = get_schema("Sigmoid", 1, "")
        op = Op(self, "Sigmoid", schema)
        return op(*self._prepare_inputs(schema, X), consumed_inputs=consumed_inputs)

    T_Size = TypeVar(
        "T_Size",
        BOOL,
        COMPLEX128,
        COMPLEX64,
        DOUBLE,
        FLOAT,
        FLOAT16,
        INT16,
        INT32,
        INT64,
        INT8,
        STRING,
        UINT16,
        UINT32,
        UINT64,
        UINT8,
    )

    T1_Size: TypeAlias = INT64

    def Size(self, data: T_Size) -> T1_Size:
        r"""[🌐 Size(1)](https://onnx.ai/onnx/operators/onnx__Size.html#size-1 "Online Documentation")


        Takes a tensor as input and outputs a int64 scalar that equals to the total number of elements of the input tensor.


        Args:
            data: An input tensor.
        """

        schema = get_schema("Size", 1, "")
        op = Op(self, "Size", schema)
        return op(*self._prepare_inputs(schema, data))

    T_Slice = TypeVar(
        "T_Slice",
        BOOL,
        COMPLEX128,
        COMPLEX64,
        DOUBLE,
        FLOAT,
        FLOAT16,
        INT16,
        INT32,
        INT64,
        INT8,
        STRING,
        UINT16,
        UINT32,
        UINT64,
        UINT8,
    )

    def Slice(
        self,
        data: T_Slice,
        *,
        axes: Optional[Sequence[int]] = None,
        ends: Sequence[int],
        starts: Sequence[int],
    ) -> T_Slice:
        r"""[🌐 Slice(1)](https://onnx.ai/onnx/operators/onnx__Slice.html#slice-1 "Online Documentation")


        Produces a slice of the input tensor along multiple axes. Similar to numpy:
        https://numpy.org/doc/stable/reference/routines.indexing.html
        Slices uses `axes`, `starts` and `ends` attributes to specify the start and end
        dimension for each axis in the list of axes, it uses this information to
        slice the input `data` tensor. If a negative value is passed for any of the
        start or end indices, it represent number of elements before the end of that
        dimension. If the value passed to start or end is larger than the `n` (the
        number of elements in this dimension), it represents `n`. For slicing to the
        end of a dimension with unknown size, it is recommended to pass in `INT_MAX`.
        If `axes` are omitted, they are set to `[0, ..., ndim-1]`.
        Example 1:
          data = [
              [1, 2, 3, 4],
              [5, 6, 7, 8],
          ]
          axes = [0, 1]
          starts = [1, 0]
          ends = [2, 3]
          result = [
              [5, 6, 7],
          ]
        Example 2:
          data = [
              [1, 2, 3, 4],
              [5, 6, 7, 8],
          ]
          starts = [0, 1]
          ends = [-1, 1000]
          result = [
              [2, 3, 4],
          ]


        Args:
            data: Tensor of data to extract slices from.

            axes: Axes that `starts` and `ends` apply to. It's optional. If not present,
                will be treated as [0, 1, ..., len(`starts`) - 1].

            ends: Ending indices (exclusive) of corresponding axis in axes`

            starts: Starting indices of corresponding axis in `axes`
        """

        schema = get_schema("Slice", 1, "")
        op = Op(self, "Slice", schema)
        return op(*self._prepare_inputs(schema, data), axes=axes, ends=ends, starts=starts)

    T_Softmax = TypeVar("T_Softmax", DOUBLE, FLOAT, FLOAT16)

    def Softmax(self, input: T_Softmax, *, axis: int = 1) -> T_Softmax:
        r"""[🌐 Softmax(1)](https://onnx.ai/onnx/operators/onnx__Softmax.html#softmax-1 "Online Documentation")


        The operator computes the softmax (normalized exponential) values for each layer in the batch
         of the given input. The input is a 2-D tensor (Tensor<float>) of size
        (batch_size x input_feature_dimensions). The output tensor has the same shape
        and contains the softmax values of the corresponding input.

        Input does not need to explicitly be a 2D vector; rather, it will be
        coerced into one. For an arbitrary n-dimensional tensor
        input \in [a_0, a_1, ..., a_{k-1}, a_k, ..., a_{n-1}] and k is
        the axis provided, then input will be coerced into a 2-dimensional tensor with
        dimensions [a_0 * ... * a_{k-1}, a_k * ... * a_{n-1}]. For the default
        case where axis=1, this means the input tensor will be coerced into a 2D tensor
        of dimensions [a_0, a_1 * ... * a_{n-1}], where a_0 is often the batch size.
        In this situation, we must have a_0 = N and a_1 * ... * a_{n-1} = D.
        Each of these dimensions must be matched correctly, or else the operator
        will throw errors.


        Args:
            input: The input tensor that's coerced into a 2D matrix of size (NxD) as
                described above.

            axis: Describes the axis of the inputs when coerced to 2D; defaults to one
                because the 0th axis most likely describes the batch_size
        """

        schema = get_schema("Softmax", 1, "")
        op = Op(self, "Softmax", schema)
        return op(*self._prepare_inputs(schema, input), axis=axis)

    T_Softplus = TypeVar("T_Softplus", DOUBLE, FLOAT, FLOAT16)

    def Softplus(self, X: T_Softplus) -> T_Softplus:
        r"""[🌐 Softplus(1)](https://onnx.ai/onnx/operators/onnx__Softplus.html#softplus-1 "Online Documentation")


        Softplus takes one input data (Tensor<T>) and produces one output data
        (Tensor<T>) where the softplus function, y = ln(exp(x) + 1), is applied to
        the tensor elementwise.


        Args:
            X: (differentiable) 1D input tensor
        """

        schema = get_schema("Softplus", 1, "")
        op = Op(self, "Softplus", schema)
        return op(*self._prepare_inputs(schema, X))

    T_Softsign = TypeVar("T_Softsign", DOUBLE, FLOAT, FLOAT16)

    def Softsign(self, input: T_Softsign) -> T_Softsign:
        r"""[🌐 Softsign(1)](https://onnx.ai/onnx/operators/onnx__Softsign.html#softsign-1 "Online Documentation")


        Calculates the softsign (x/(1+|x|)) of the given input tensor element-wise.


        Args:
            input: (differentiable) Input tensor
        """

        schema = get_schema("Softsign", 1, "")
        op = Op(self, "Softsign", schema)
        return op(*self._prepare_inputs(schema, input))

    T_SpaceToDepth = TypeVar(
        "T_SpaceToDepth",
        BOOL,
        COMPLEX128,
        COMPLEX64,
        DOUBLE,
        FLOAT,
        FLOAT16,
        INT16,
        INT32,
        INT64,
        INT8,
        STRING,
        UINT16,
        UINT32,
        UINT64,
        UINT8,
    )

    def SpaceToDepth(self, input: T_SpaceToDepth, *, blocksize: int) -> T_SpaceToDepth:
        r"""[🌐 SpaceToDepth(1)](https://onnx.ai/onnx/operators/onnx__SpaceToDepth.html#spacetodepth-1 "Online Documentation")

        SpaceToDepth rearranges blocks of spatial data into depth. More specifically,
        this op outputs a copy of the input tensor where values from the height and width dimensions
        are moved to the depth dimension.


        Args:
            input: Input tensor of [N,C,H,W], where N is the batch axis, C is the
                channel or depth, H is the height and W is the width.

            blocksize: Blocks of [blocksize, blocksize] are moved.
        """

        schema = get_schema("SpaceToDepth", 1, "")
        op = Op(self, "SpaceToDepth", schema)
        return op(*self._prepare_inputs(schema, input), blocksize=blocksize)

    T_Split = TypeVar("T_Split", DOUBLE, FLOAT, FLOAT16)

    def Split(
        self,
        input: T_Split,
        split_: Optional[T_Split] = None,
        *,
        axis: Optional[int] = None,
        split: Optional[Sequence[int]] = None,
    ) -> T_Split:
        r"""[🌐 Split(1)](https://onnx.ai/onnx/operators/onnx__Split.html#split-1 "Online Documentation")

        Split a tensor into a list of tensors, along the specified
        'axis'. The lengths of the split can be specified using argument 'axis' or
        optional second input blob to the operator. Otherwise, the tensor is split
        to equal sized parts.


        Args:
            input: The tensor to split

            split_: (optional) Optional list of output lengths (see also arg 'split')

            axis: Which axis to split on

            split: length of each output
        """

        schema = get_schema("Split", 1, "")
        op = Op(self, "Split", schema)
        return op(*self._prepare_inputs(schema, input, split_), axis=axis, split=split)

    T_Sqrt = TypeVar("T_Sqrt", DOUBLE, FLOAT, FLOAT16)

    def Sqrt(self, X: T_Sqrt, *, consumed_inputs: Optional[Sequence[int]] = None) -> T_Sqrt:
        r"""[🌐 Sqrt(1)](https://onnx.ai/onnx/operators/onnx__Sqrt.html#sqrt-1 "Online Documentation")


        Square root takes one input data (Tensor<T>) and produces one output data
        (Tensor<T>) where the square root is, y = x^0.5, is applied to
        the tensor elementwise. If x is negative, then it will return NaN.


        Args:
            X: Input tensor

            consumed_inputs: legacy optimization attribute.
        """

        schema = get_schema("Sqrt", 1, "")
        op = Op(self, "Sqrt", schema)
        return op(*self._prepare_inputs(schema, X), consumed_inputs=consumed_inputs)

    T_Squeeze = TypeVar(
        "T_Squeeze",
        BOOL,
        COMPLEX128,
        COMPLEX64,
        DOUBLE,
        FLOAT,
        FLOAT16,
        INT16,
        INT32,
        INT64,
        INT8,
        STRING,
        UINT16,
        UINT32,
        UINT64,
        UINT8,
    )

    def Squeeze(self, data: T_Squeeze, *, axes: Optional[Sequence[int]] = None) -> T_Squeeze:
        r"""[🌐 Squeeze(1)](https://onnx.ai/onnx/operators/onnx__Squeeze.html#squeeze-1 "Online Documentation")


        Remove single-dimensional entries from the shape of a tensor.
        Takes a  parameter `axes` with a list of axes to squeeze.
        If `axes` is not provided, all the single dimensions will be removed from
        the shape. If an axis is selected with shape entry not equal to one, an error is raised.


        Args:
            data: Tensors with at least max(dims) dimensions.

            axes: List of non-negative integers, indicate the dimensions to squeeze.
        """

        schema = get_schema("Squeeze", 1, "")
        op = Op(self, "Squeeze", schema)
        return op(*self._prepare_inputs(schema, data), axes=axes)

    T_Sub = TypeVar("T_Sub", DOUBLE, FLOAT, FLOAT16)

    def Sub(
        self,
        A: T_Sub,
        B: T_Sub,
        *,
        axis: Optional[int] = None,
        broadcast: int = 0,
        consumed_inputs: Optional[Sequence[int]] = None,
    ) -> T_Sub:
        r"""[🌐 Sub(1)](https://onnx.ai/onnx/operators/onnx__Sub.html#sub-1 "Online Documentation")


        Performs element-wise binary subtraction (with limited broadcast support).

        If necessary the right-hand-side argument will be broadcasted to match the
        shape of left-hand-side argument. When broadcasting is specified, the second
        tensor can either be of element size 1 (including a scalar tensor and any
        tensor with rank equal to or smaller than the first tensor), or having its
        shape as a contiguous subset of the first tensor's shape. The starting of the
        mutually equal shape is specified by the argument "axis", and if it is not set,
        suffix matching is assumed. 1-dim expansion doesn't work yet.

        For example, the following tensor shapes are supported (with broadcast=1):

          shape(A) = (2, 3, 4, 5), shape(B) = (,), i.e. B is a scalar tensor
          shape(A) = (2, 3, 4, 5), shape(B) = (1, 1), i.e. B is an 1-element tensor
          shape(A) = (2, 3, 4, 5), shape(B) = (5,)
          shape(A) = (2, 3, 4, 5), shape(B) = (4, 5)
          shape(A) = (2, 3, 4, 5), shape(B) = (3, 4), with axis=1
          shape(A) = (2, 3, 4, 5), shape(B) = (2), with axis=0

        Attribute `broadcast=1` needs to be passed to enable broadcasting.


        Args:
            A: First operand, should share the type with the second operand.

            B: Second operand. With broadcasting can be of smaller size than A. If
                broadcasting is disabled it should be of the same size.

            axis: If set, defines the broadcast dimensions. See doc for details.

            broadcast: Pass 1 to enable broadcasting

            consumed_inputs: legacy optimization attribute.
        """

        schema = get_schema("Sub", 1, "")
        op = Op(self, "Sub", schema)
        return op(
            *self._prepare_inputs(schema, A, B),
            axis=axis,
            broadcast=broadcast,
            consumed_inputs=consumed_inputs,
        )

    T_Sum = TypeVar("T_Sum", DOUBLE, FLOAT, FLOAT16)

    def Sum(self, *data_0: T_Sum, consumed_inputs: Optional[Sequence[int]] = None) -> T_Sum:
        r"""[🌐 Sum(1)](https://onnx.ai/onnx/operators/onnx__Sum.html#sum-1 "Online Documentation")


        Element-wise sum of each of the input tensors. All inputs and outputs must
        have the same shape and data type.


        Args:
            data_0: (variadic) List of tensors for Sum.

            consumed_inputs: legacy optimization attribute.
        """

        schema = get_schema("Sum", 1, "")
        op = Op(self, "Sum", schema)
        return op(*self._prepare_inputs(schema, *data_0), consumed_inputs=consumed_inputs)

    T_Tanh = TypeVar("T_Tanh", DOUBLE, FLOAT, FLOAT16)

    def Tanh(
        self, input: T_Tanh, *, consumed_inputs: Optional[Sequence[int]] = None
    ) -> T_Tanh:
        r"""[🌐 Tanh(1)](https://onnx.ai/onnx/operators/onnx__Tanh.html#tanh-1 "Online Documentation")


        Calculates the hyperbolic tangent of the given input tensor element-wise.


        Args:
            input: 1-D input tensor

            consumed_inputs: legacy optimization attribute.
        """

        schema = get_schema("Tanh", 1, "")
        op = Op(self, "Tanh", schema)
        return op(*self._prepare_inputs(schema, input), consumed_inputs=consumed_inputs)

    T_Tile = TypeVar("T_Tile", DOUBLE, FLOAT, FLOAT16)

    def Tile(self, input: T_Tile, tiles: T_Tile, axis: T_Tile) -> T_Tile:
        r"""[🌐 Tile(1)](https://onnx.ai/onnx/operators/onnx__Tile.html#tile-1 "Online Documentation")

        Repeat the elements of a tensor along an axis.

        Args:
            input: Input tensor of any shape.

            tiles: Number of repeated copies to make of the input tensor.

            axis: Axis along which to repeat.
        """

        schema = get_schema("Tile", 1, "")
        op = Op(self, "Tile", schema)
        return op(*self._prepare_inputs(schema, input, tiles, axis))

    T_TopK = TypeVar("T_TopK", DOUBLE, FLOAT, FLOAT16)

    I_TopK: TypeAlias = INT64

    def TopK(self, X: T_TopK, *, axis: int = -1, k: int) -> Tuple[T_TopK, I_TopK]:
        r"""[🌐 TopK(1)](https://onnx.ai/onnx/operators/onnx__TopK.html#topk-1 "Online Documentation")


        Retrieve the top-K elements along a specified axis. Given an input tensor of
        shape [a_0, a_1, ..., a_{n-1}] and integer argument k, return two outputs:
          -Value tensor of shape [a_0, a_1, ..., a_{axis-1}, k, a_{axis+1}, ... a_{n-1}]
            which contains the values of the top k elements along the specified axis
          -Index tensor of shape [a_0, a_1, ..., a_{axis-1}, k, a_{axis+1}, ... a_{n-1}] which
           contains the indices of the top k elements (original indices from the input
           tensor).
        Given two equivalent values, this operator uses the indices along the axis  as
         a tiebreaker. That is, the element with the lower index will appear first.


        Args:
            X: Tensor of shape [a_0, a_1, ..., a_{n-1}]

            axis: Dimension on which to do the sort.

            k: Number of top elements to retrieve
        """

        schema = get_schema("TopK", 1, "")
        op = Op(self, "TopK", schema)
        return op(*self._prepare_inputs(schema, X), axis=axis, k=k)

    T_Transpose = TypeVar(
        "T_Transpose",
        BOOL,
        COMPLEX128,
        COMPLEX64,
        DOUBLE,
        FLOAT,
        FLOAT16,
        INT16,
        INT32,
        INT64,
        INT8,
        STRING,
        UINT16,
        UINT32,
        UINT64,
        UINT8,
    )

    def Transpose(
        self, data: T_Transpose, *, perm: Optional[Sequence[int]] = None
    ) -> T_Transpose:
        r"""[🌐 Transpose(1)](https://onnx.ai/onnx/operators/onnx__Transpose.html#transpose-1 "Online Documentation")


        Transpose the input tensor similar to numpy.transpose. For example, when
        perm=(1, 0, 2), given an input tensor of shape (1, 2, 3), the output shape
        will be (2, 1, 3).


        Args:
            data: An input tensor.

            perm: A list of integers. By default, reverse the dimensions, otherwise
                permute the axes according to the values given.
        """

        schema = get_schema("Transpose", 1, "")
        op = Op(self, "Transpose", schema)
        return op(*self._prepare_inputs(schema, data), perm=perm)

    T_Unsqueeze = TypeVar(
        "T_Unsqueeze",
        BOOL,
        COMPLEX128,
        COMPLEX64,
        DOUBLE,
        FLOAT,
        FLOAT16,
        INT16,
        INT32,
        INT64,
        INT8,
        STRING,
        UINT16,
        UINT32,
        UINT64,
        UINT8,
    )

    def Unsqueeze(self, data: T_Unsqueeze, *, axes: Sequence[int]) -> T_Unsqueeze:
        r"""[🌐 Unsqueeze(1)](https://onnx.ai/onnx/operators/onnx__Unsqueeze.html#unsqueeze-1 "Online Documentation")


        Insert single-dimensional entries to the shape of a tensor.
        Takes one required argument `axes`, a list of dimensions that will be inserted.
        Dimension indices in `axes` are as seen in the output tensor. For example:
          Given a tensor such that tensor with shape [3, 4, 5], then
          Unsqueeze(tensor, axes=[0, 4]) has shape [1, 3, 4, 5, 1]


        Args:
            data: Original tensor

            axes: List of non-negative integers, indicate the dimensions to be inserted
        """

        schema = get_schema("Unsqueeze", 1, "")
        op = Op(self, "Unsqueeze", schema)
        return op(*self._prepare_inputs(schema, data), axes=axes)

    T_Upsample = TypeVar("T_Upsample", BOOL, DOUBLE, FLOAT, FLOAT16, INT32, INT64)

    def Upsample(
        self, X: T_Upsample, *, height_scale: float, mode: str = "nearest", width_scale: float
    ) -> T_Upsample:
        r"""[🌐 Upsample(1)](https://onnx.ai/onnx/operators/onnx__Upsample.html#upsample-1 "Online Documentation")


        Upsample the input tensor.
        The width and height of the output tensor are:
          output_width = floor(input_width * width_scale),
          output_height = floor(input_height * height_scale).
        Example:
          Given `data` tensor, width_scale, height_scale, mode,
          Upsample the input 4-D tensor in nearest mode:
          data = [[[
              [1, 2],
              [3, 4]
          ]]]
          width_scale = 2
          height_scale = 2
          mode = "nearest"
          output = [[[
              [1, 1, 2, 2],
              [1, 1, 2, 2],
              [3, 3, 4, 4],
              [3, 3, 4, 4]
          ]]]


        Args:
            X: 4-D tensor, [N,C,H,W]

            height_scale: The scale along height dimension. It takes value greater than
                or equal to 1.

            mode: Two interpolation modes: nearest(default), bilinear

            width_scale: The scale along width dimension. It takes value greater than or
                equal to 1.
        """

        schema = get_schema("Upsample", 1, "")
        op = Op(self, "Upsample", schema)
        return op(
            *self._prepare_inputs(schema, X),
            height_scale=height_scale,
            mode=mode,
            width_scale=width_scale,
        )

    T_Xor: TypeAlias = BOOL

    T1_Xor: TypeAlias = BOOL

    def Xor(
        self, A: T_Xor, B: T_Xor, *, axis: Optional[int] = None, broadcast: int = 0
    ) -> T1_Xor:
        r"""[🌐 Xor(1)](https://onnx.ai/onnx/operators/onnx__Xor.html#xor-1 "Online Documentation")


        Returns the tensor resulted from performing the `xor` logical operation
        elementwise on the input tensors `A` and `B`.

        If broadcasting is enabled, the right-hand-side argument will be broadcasted
        to match the shape of left-hand-side argument. See the doc of `Add` for a
        detailed description of the broadcasting rules.


        Args:
            A: Left input tensor for the logical operator.

            B: Right input tensor for the logical operator.

            axis: If set, defines the broadcast dimensions.

            broadcast: Enable broadcasting
        """

        schema = get_schema("Xor", 1, "")
        op = Op(self, "Xor", schema)
        return op(*self._prepare_inputs(schema, A, B), axis=axis, broadcast=broadcast)
