# Contributing to Merlin

Merlin is a community oriented open-source project and we encourage and value
any kind of contribution. Thanks for taking the time to contribute 🐫 !

## Code of Conduct

Merlin  adheres to the OCaml Code of Conduct as stated in the [Code of Conduct
document](CODE_OF_CONDUCT.md). By participating, you are expected to uphold this
code. Please report unacceptable behavior either to local contacts (listed in
[here](CODE_OF_CONDUCT.md)) or to someone listed in the upstream [OCaml Code of
Conduct](CODE_OF_CONDUCT.md).

## Documentation

Merlin (partial and fragmented) documentation can be found in the following
places:
- Installation instructions and editor setup can be found in the
  [README.md](README.md) and the [Github Pages](https://ocaml.github.io/merlin/)
- Various topics related to editor support and configuration can be found in the
  [wiki](https://github.com/ocaml/merlin/wiki).
- The Merlin protocol is described in [this
  document](https://github.com/ocaml/merlin/blob/master/doc/dev/PROTOCOL.md).

Contributions to the documentation are welcome!

## Question, bug reports and feature requests

We rely on [Github's issue tracker](https://github.com/ocaml/merlin/issues) for
support questions, feature requests and bug reports.

When reporting an issue, please include a precise reproduction in the bug report
when that's possible, as it is a very useful tool to investigate. You should
also check that you are using the latest version of Merlin and that a similar
issue has not already been submitted.

## Code contributions

### Styleguides

Merlin uses ocamlformat. When contributing code, please always format it by
running `dune fmt` before submitting a PR. The required version of ocamlformat
can be found in the `.ocamlformat` configuration file.

Changes unrelated to the issue addressed by a PR should be made in a separate
PR. Additionally, formatting changes in parts of the code not concerned by a
specific PR should be proposed in another PR.

Ideally, any opened issue should be accompanied by a test with a reproduction.
When working on a fix for an issue, the first commit should contain the test
showing the issue. Following commits should fix the issue and update the test
result accordingly.

### Menhir version

Merlin promotes the generated Menhir parser in its sources. This is done to
avoid depending on Menhir when installing Merlin. However this also means that
unnecessary diff will appear when the parser gets re-generated by a different
version of Menhir. To remove this diff please use version `20201216`:
```bash
$ opam pin menhir 20201216
```
The generated parser file should only be commited if there is an actual change
in the grammar.

### Repository organization

There is a partial overview over the repo organization with file-granularity at
[ARCHITECTURE.md](https://github.com/ocaml/merlin/blob/master/doc/dev/ARCHITECTURE.md).
Here is a more high-level overview.

#### `/src/ocaml`
Vendored OCaml typer. Also include Merlin's incremental parser and other
utilites. Changes to these modules should be kept minimal as these patches need
to be reapplied for each new version of the compiler.

#### `/src/kernel`
The backbone of merlin. Contains configuration utilities and pipeline
management. The pipeline describes the compilation workflow: parsing, ppxing and
typing.

#### `/src/frontend/query_protocol.ml`
The type description of Merlin's protocol as documented in
[PROTOCOL.md](https://github.com/ocaml/merlin/blob/master/doc/dev/PROTOCOL.md)

#### `/src/frontend/query_commands.ml`
This file contains the dispatcher: a large pattern matching that answers
Merlin's queries. Most of the time answering a query begins with getting the
Typedtree from the pipeline and calling the correct analysis functions.

#### `/src/analysis`
Contains most of Merlin logic required to answer the queries.

#### `/src/dot-protocol`
The configuration protocol that configuration servers such as
`dot-merlin-reader` or `dune ocaml-merlin` should implement.

#### `/src/dot-merlin-reader`
The historical configuration server of Merlin. It reads `.merlin` configuration
files whose syntax is [documented in the
wiki](https://github.com/ocaml/merlin/wiki/Project-configuration).

#### `/src/frontend/ocamlmerlin`
The standard Merlin frontend, composed of a long-running server and a client.
This is the frontend used by the test-suite and standard emacs and vim plugins.
For an alternative frontend, see
[ocaml-lsp-server](https://github.com/ocaml/ocaml-lsp/)

#### `/tests/test-dirs`
Merlin's behavioral test-suite. We rely on Dune's cram test framework.

#### `/emacs`
The emacs editor mode.

#### `/vim`
The vim plugin.
