/*
 * Decompiled with CFR 0.152.
 */
package spec.reporter;

import spec.reporter.ReportProps;
import spec.reporter.Result;

public class Run {
    static final String COPYRIGHT = "SPECjbb2005,Copyright (c) 2000-2005 Standard Performance Evaluation Corporation (SPEC),All rights reserved,Copyright (c) 2000-2005 Hewlett-Packard,All rights reserved,Copyright (c) 1997-2005 Sun Microsystems, Inc.All rights reserved,Licensed Materials - Property of SPEC";
    private static final double MB = 1048576.0;
    public int count;
    public double totaltime;
    public double minimumtime;
    public double maximumtime;
    public double averagetime;
    public double usedMemoryEnd;
    public double usedMemoryStart;
    private ReportProps props;
    public Result result;
    public double time;
    public double totalMemoryEnd;
    public double totalMemoryStart;
    public static String[] transaction = new String[]{"new_order", "payment", "order_status", "delivery", "stock_level", "cust_report"};

    public Run(ReportProps reportProps, int n, double d, Result result) {
        this.props = reportProps;
        this.time = d;
        this.result = result;
        String string = "result." + result.name + ".company." + transaction[n];
        this.count = reportProps.getInt(string + ".count");
        this.totaltime = reportProps.getDouble(string + ".totaltime");
        this.minimumtime = reportProps.getDouble(string + ".minimumtime");
        this.maximumtime = reportProps.getDouble(string + ".maximumtime");
        this.averagetime = reportProps.getDouble(string + ".averagetime");
    }

    public double ratio() {
        double d = this.result.referenceTime;
        if (this.time <= 0.0) {
            return 0.0;
        }
        return d / this.time;
    }
}

