#include <kdb.hpp>

#include <keyio.hpp>
#include <keysetio.hpp>
#include <kdbio.hpp>

int main()
{
	kdb::Key k("user/sw/MyApp", KEY_END);
	std::cout << "created a key: " << k << std::endl;

	kdb::KeySet ks;

	try
	{
		kdb::KDB kdb(k);
		kdb.get(ks, k);

		std::cout << "print out (full) keyset:" << std::endl;
		std::cout << ks;

		kdb.set(ks, k);
		kdb.close(k);
		printWarnings(std::cout, k);
	}
	catch (kdb::KDBException const & e)
	{
		std::cout << e.what();
	}
}
